/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.metrics.autoconfigure.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.cusc.nirvana.metrics.autoconfigure.druid.DruidDataSourcePoolMetadata;
import com.cusc.nirvana.metrics.autoconfigure.druid.DruidMetrics;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DruidDataSource.class, ShardingDataSource.class})
public class ShardingMetricsAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShardingMetricsAutoConfiguration.class);

    @Bean
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnMissingBean
    public DruidMetrics druidMetrics(List<DataSource> dataSourceList) {
        LOGGER.info("Found {} datasource", (Object)dataSourceList.size());
        HashSet<DruidDataSource> druidDataSourceList = new HashSet<DruidDataSource>();
        for (DataSource dataSource : dataSourceList) {
            if (dataSource instanceof DruidDataSource) {
                druidDataSourceList.add((DruidDataSource)dataSource);
                continue;
            }
            if (dataSource instanceof AbstractRoutingDataSource) {
                try {
                    if (!dataSource.isWrapperFor(DruidDataSource.class)) continue;
                    druidDataSourceList.add(dataSource.unwrap(DruidDataSource.class));
                }
                catch (SQLException e) {
                    LOGGER.error("DataSource is not DruidDataSource", (Throwable)e);
                }
                continue;
            }
            if (dataSource instanceof ShardingDataSource) {
                Set entries = ((ShardingDataSource)dataSource).getDataSourceMap().entrySet();
                for (Map.Entry entry : entries) {
                    if (!(entry.getValue() instanceof DruidDataSource)) continue;
                    druidDataSourceList.add((DruidDataSource)entry.getValue());
                }
                continue;
            }
            LOGGER.info("None DruidDataSource found");
        }
        for (DruidDataSource druidDataSource : druidDataSourceList) {
            LOGGER.info("Exporting metrics for {} datasource", (Object)druidDataSource.getName());
        }
        return new DruidMetrics(druidDataSourceList);
    }

    @Bean
    public DataSourcePoolMetadataProvider druidPoolDataSourceMetadataProvider() {
        return dataSource -> {
            if (dataSource instanceof AbstractRoutingDataSource) {
                try {
                    if (dataSource.isWrapperFor(DruidDataSource.class)) {
                        return new DruidDataSourcePoolMetadata(dataSource.unwrap(DruidDataSource.class));
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("Initialize DataSourcePoolMetadataProvider error", (Throwable)e);
                }
            }
            if (dataSource instanceof DruidDataSource) {
                DruidDataSource druidDataSource = (DruidDataSource)dataSource;
                return new DruidDataSourcePoolMetadata(druidDataSource);
            }
            return null;
        };
    }
}

