/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.metrics.autoconfigure.druid;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Set;
import org.springframework.lang.NonNull;

public class DruidMetrics
implements MeterBinder {
    private Set<DruidDataSource> druidDataSourceList;

    public DruidMetrics(Set<DruidDataSource> druidDataSourceList) {
        this.druidDataSourceList = druidDataSourceList;
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        for (DruidDataSource druidDataSource : this.druidDataSourceList) {
            Gauge.builder((String)"druid.pooling.count", (Object)druidDataSource, DruidDataSource::getPoolingCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.pooling.peak", (Object)druidDataSource, DruidDataSource::getPoolingPeak).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.close.count", (Object)druidDataSource, DruidDataSource::getCloseCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.commit.count", (Object)druidDataSource, DruidAbstractDataSource::getCommitCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.error.count", (Object)druidDataSource, DruidDataSource::getErrorCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.active.count", (Object)druidDataSource, DruidDataSource::getActiveCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.active.peak", (Object)druidDataSource, DruidDataSource::getActivePeak).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.create.count", (Object)druidDataSource, DruidDataSource::getCreateCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.connect.count", (Object)druidDataSource, DruidDataSource::getConnectCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.destroy.count", (Object)druidDataSource, DruidDataSource::getDestroyCount).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.max.active", (Object)druidDataSource, DruidAbstractDataSource::getMaxActive).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.max.idle", (Object)druidDataSource, DruidAbstractDataSource::getMaxIdle).tag("pool", druidDataSource.getName()).register(registry);
            Gauge.builder((String)"druid.min.idle", (Object)druidDataSource, DruidAbstractDataSource::getMinIdle).tag("pool", druidDataSource.getName()).register(registry);
        }
    }
}

