/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.log.function;

import com.cusc.nirvana.log.function.LogRecordFunc;
import com.cusc.nirvana.log.spring.DefaultPrintInfoListener;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public class CustomFunctionRegistrar
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPrintInfoListener.class);
    private ApplicationContext applicationContext;
    private static Map<String, Method> functionMap = new HashMap<String, Method>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Map beanWithAnnotation = applicationContext.getBeansWithAnnotation(LogRecordFunc.class);
        beanWithAnnotation.values().forEach(component -> {
            Method[] methods = component.getClass().getMethods();
            LogRecordFunc classLogRecordFunc = component.getClass().getAnnotation(LogRecordFunc.class);
            String prefixName = classLogRecordFunc.value();
            if (StringUtils.hasText((String)prefixName)) {
                prefixName = prefixName + "_";
            }
            if (methods.length > 0) {
                for (Method method : methods) {
                    if (!method.isAnnotationPresent(LogRecordFunc.class) || !CustomFunctionRegistrar.isStaticMethod(method)) continue;
                    LogRecordFunc logRecordFunc = method.getAnnotation(LogRecordFunc.class);
                    String registerName = StringUtils.hasText((String)logRecordFunc.value()) ? logRecordFunc.value() : method.getName();
                    functionMap.put(prefixName + registerName, method);
                    logger.info("LogRecord register custom function [{}] as name [{}]", (Object)method, (Object)registerName);
                }
            }
        });
    }

    public static void register(StandardEvaluationContext context) {
        functionMap.forEach((arg_0, arg_1) -> ((StandardEvaluationContext)context).registerFunction(arg_0, arg_1));
    }

    private static boolean isStaticMethod(Method method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isStatic(modifiers);
    }
}

