/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.log.format;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;

public class LogDateConverter
extends ClassicConverter {
    ThreadLocal<CachingDateFormatter> cache = ThreadLocal.withInitial(() -> this.initCachingDateFormatter());

    public String convert(ILoggingEvent event) {
        long timestamp = event.getTimeStamp();
        if (Objects.nonNull(this.cache.get())) {
            return this.cache.get().format(timestamp);
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date(timestamp));
    }

    public void stop() {
        super.stop();
        this.cache.remove();
    }

    public CachingDateFormatter initCachingDateFormatter() {
        CachingDateFormatter cachingDateFormatter;
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            cachingDateFormatter = new CachingDateFormatter(datePattern);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS");
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone((String)optionList.get(1));
            cachingDateFormatter.setTimeZone(tz);
        }
        return cachingDateFormatter;
    }
}

