/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.log.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cusc.nirvana.log.annotation.OperateLog;
import com.cusc.nirvana.log.context.LogRecordContext;
import com.cusc.nirvana.log.dto.LogDTO;
import com.cusc.nirvana.log.function.CustomFunctionRegistrar;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class OperateLogAspect {
    private final Logger operatorLog = LoggerFactory.getLogger((String)"OPERATOR_LOG");
    private final Logger log = LoggerFactory.getLogger(OperateLogAspect.class);
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private final DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();

    @Around(value="@annotation(com.cusc.nirvana.log.annotation.OperateLog)")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Object result;
        List<Object> logS = new ArrayList();
        StopWatch stopWatch = new StopWatch();
        try {
            logS = this.resolveExpress((JoinPoint)pjp);
            stopWatch.start();
            result = pjp.proceed();
            stopWatch.stop();
            logS.forEach(logDTO -> logDTO.setSuccess(true));
        }
        catch (Throwable throwable) {
            stopWatch.stop();
            logS = this.resolveExpress((JoinPoint)pjp);
            logS.forEach(logDTO -> {
                logDTO.setSuccess(false);
                logDTO.setException(throwable.getMessage());
            });
            throw throwable;
        }
        finally {
            logS.forEach(logDTO -> {
                try {
                    MDC.put((String)"bizId", (String)logDTO.getBizId());
                    MDC.put((String)"operator", (String)logDTO.getOperator());
                    MDC.put((String)"operateType", (String)logDTO.getOperateType().getValue());
                    MDC.put((String)"operateDate", (String)this.dateFormat(logDTO.getOperateDate()));
                    MDC.put((String)"operateResult", (String)(logDTO.getSuccess() != false ? "true" : "false"));
                    MDC.put((String)"operateExp", (String)logDTO.getException());
                    MDC.put((String)"traceId", (String)TraceContext.traceId());
                    this.operatorLog.info(logDTO.getMsg());
                }
                catch (Throwable throwable) {
                    this.log.error("OperateLogAspect doAround send log error", throwable);
                }
            });
            LogRecordContext.clearContext();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogDTO> resolveExpress(JoinPoint joinPoint) {
        try {
            OperateLog[] annotations;
            ArrayList<LogDTO> logDTOList = new ArrayList<LogDTO>();
            Object[] arguments = joinPoint.getArgs();
            Method method = this.getMethod(joinPoint);
            for (OperateLog annotation : annotations = (OperateLog[])method.getAnnotationsByType(OperateLog.class)) {
                LogDTO logDTO = new LogDTO();
                logDTOList.add(logDTO);
                String bizIdSpel = annotation.bizId();
                String operatorSpel = annotation.operator();
                String msgSpel = annotation.msg();
                String bizId = bizIdSpel;
                String operator = operatorSpel;
                String msg = msgSpel;
                try {
                    String[] params = this.discoverer.getParameterNames(method);
                    StandardEvaluationContext context = LogRecordContext.getContext();
                    CustomFunctionRegistrar.register(context);
                    if (params != null) {
                        for (int len = 0; len < params.length; ++len) {
                            context.setVariable(params[len], arguments[len]);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)bizIdSpel)) {
                        Expression bizIdExpression = this.parser.parseExpression(bizIdSpel);
                        bizId = (String)bizIdExpression.getValue((EvaluationContext)context, String.class);
                    }
                    if (StringUtils.isNotBlank((CharSequence)operatorSpel)) {
                        Expression operatorExpression = this.parser.parseExpression(operatorSpel);
                        operator = (String)operatorExpression.getValue((EvaluationContext)context, String.class);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)msgSpel)) continue;
                    Expression msgExpression = this.parser.parseExpression(msgSpel);
                    Object msgObj = msgExpression.getValue((EvaluationContext)context, Object.class);
                    msg = msgObj instanceof String ? String.valueOf(msgObj) : JSON.toJSONString((Object)msgObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                }
                catch (Exception e) {
                    this.log.error("OperateLogAspect resolveExpress error", (Throwable)e);
                }
                finally {
                    logDTO.setOperator(operator);
                    logDTO.setBizId(bizId);
                    logDTO.setOperateType(annotation.operatorType());
                    logDTO.setOperateDate(new Date());
                    logDTO.setMsg(msg);
                }
            }
            return logDTOList;
        }
        catch (Exception e) {
            this.log.error("OperateLogAspect resolveExpress error", (Throwable)e);
            return new ArrayList<LogDTO>();
        }
    }

    protected Method getMethod(JoinPoint joinPoint) {
        Method method = null;
        try {
            Signature signature = joinPoint.getSignature();
            MethodSignature ms = (MethodSignature)signature;
            Object target = joinPoint.getTarget();
            method = target.getClass().getMethod(ms.getName(), ms.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            this.log.error("OperateLogAspect getMethod error", (Throwable)e);
        }
        return method;
    }

    private String dateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        return simpleDateFormat.format(date);
    }
}

