package com.cusc.nirvana.log.annotation;

import com.cusc.nirvana.log.enums.OperateType;

import java.lang.annotation.*;

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface OperateLog {

    //业务ID
    String bizId() default "";

    //操作日志的执行人
    String operator() default "";

    //操作类型，主要是查询、新增、修改、删除
    OperateType operatorType() default OperateType.UNKNOWN;

    //记录操作日志的修改详情
    String msg() default "";

}
