package com.cusc.nirvana.log.filter;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author jeff.chen
 * @file LogLimiterFilter
 * @E-mail chenjf159@chinaunicom.cn
 */
public class LogLimiterFilter extends AbstractMatcherFilter<ILoggingEvent> {

    Logger logger = LoggerFactory.getLogger(LogLimiterFilter.class);

    static LogLimiterFilter thisObject;

    static final int DEFAULT_PERCENT = 100;

    Level level;

    @Override
    public FilterReply decide(ILoggingEvent event) {
        return FilterReply.NEUTRAL;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return level;
    }

    public static LogLimiterFilter getInstance() {
        return thisObject;
    }

    @Override
    public void start() {
        try {
            if (this.level != null) {
                super.start();
                thisObject = this;
            }
        } catch (Exception ex) {
            logger.error("日志组件 LogLimiterFilter 加载失败: ", ex);
        }
    }

}
