/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.uid;

import com.cusc.nirvana.common.uid.UID;
import com.cusc.nirvana.common.uid.UtilTools;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class UniqueID
implements UID {
    final String ADDRESS;
    final String PROCESS_ID;
    final AtomicLong sequenceCounter = new AtomicLong(0L);
    static final int SEQUENCE_BIT_25 = 0x1FFFFFF;
    static final int SEQUENCE_COUNTER_LEN = 5;
    private long lastTimeOfMillis = System.currentTimeMillis();
    final AtomicLong clockCallbackCounter = new AtomicLong(0L);
    static final int SEQUENCE_BIT_15 = Short.MAX_VALUE;
    static final int CLOCK_CALLBACK_COUNTER_LEN = 3;
    static final int FIXED_LEN = 32;

    private UniqueID(Type type) {
        if (Type.MAC.equals((Object)type)) {
            this.ADDRESS = UtilTools.getLocalMac();
        } else if (Type.IP.equals((Object)type)) {
            this.ADDRESS = UtilTools.getLocalIP();
        } else {
            throw new IllegalArgumentException("not support@" + type.name());
        }
        this.PROCESS_ID = String.format("%05d", UtilTools.getProcessID());
    }

    @Override
    public String ID() {
        long currentTimeOfMillis = this.currentTimeMillis();
        if (currentTimeOfMillis < this.lastTimeOfMillis) {
            this.clockCallbackCounter.incrementAndGet();
        } else if (this.lastTimeOfMillis < currentTimeOfMillis) {
            this.lastTimeOfMillis = currentTimeOfMillis;
        }
        return this.ID0(currentTimeOfMillis);
    }

    private String ID0(long currentTimeOfMillis) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.ADDRESS);
        stringBuilder.append(this.PROCESS_ID);
        stringBuilder.append(UtilTools.base10ToBase32String(currentTimeOfMillis));
        long sequence = this.sequenceCounter.incrementAndGet() & 0x1FFFFFFL;
        stringBuilder.append(UtilTools.appendPrefixWithFixedLength(UtilTools.base10ToBase32String(sequence), 5));
        long clockCallback = this.clockCallbackCounter.get() & 0x7FFFL;
        stringBuilder.append(UtilTools.appendPrefixWithFixedLength(UtilTools.base10ToBase32String(clockCallback), 3));
        return stringBuilder.toString();
    }

    public static UID getInstance(Type type) {
        return UniqueIDHolder.get(type);
    }

    public static enum Type {
        MAC,
        IP;

    }

    static class UniqueIDHolder {
        static final ConcurrentMap<Type, UID> CACHE = new ConcurrentHashMap<Type, UID>();

        UniqueIDHolder() {
        }

        public static UID get(Type type) {
            return (UID)CACHE.get((Object)type);
        }

        static {
            CACHE.put(Type.IP, new UniqueID(Type.IP));
            CACHE.put(Type.MAC, new UniqueID(Type.MAC));
        }
    }
}

