/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.result;

import java.util.ArrayList;
import java.util.List;

public class PageResult<T> {
    private static final long serialVersionUID = 1L;
    private long totalCount;
    private long pageSize;
    private long currPage;
    private List<T> list;
    private boolean hasMore;

    public PageResult() {
    }

    public PageResult(List<T> list, long totalCount, long pageSize, long currPage) {
        this.list = list;
        this.totalCount = totalCount;
        this.pageSize = pageSize;
        this.currPage = currPage;
    }

    public PageResult(List<T> list, long totalCount, long pageSize) {
        this.list = list;
        this.totalCount = totalCount;
        this.pageSize = pageSize;
    }

    public PageResult(long currPage, long pageSize) {
        this.currPage = currPage;
        this.pageSize = pageSize;
    }

    public static PageResult createError(String msg) {
        PageResult page = new PageResult();
        return page;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public long getCurrPage() {
        return this.currPage;
    }

    public void setCurrPage(long currPage) {
        this.currPage = currPage;
    }

    public List<T> getList() {
        if (this.list == null || this.list.isEmpty()) {
            this.list = new ArrayList<T>(0);
        }
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public boolean isHasMore() {
        this.hasMore = this.totalCount - this.currPage * this.pageSize > 0L;
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }
}

