/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.http.client;

import com.cusc.nirvana.common.http.client.HttpBase;
import com.cusc.nirvana.common.http.client.HttpHook;
import com.cusc.nirvana.common.http.client.HttpMethod;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSync
extends HttpBase {
    static final Logger logger = LoggerFactory.getLogger(HttpSync.class);

    public static String get(String url) {
        return HttpSync.execResultWithString(url, HttpSync.getRequest(url, null));
    }

    public static String get(String url, Map<String, String> headers) {
        return HttpSync.execResultWithString(url, HttpSync.getRequest(url, headers));
    }

    public static String post(String url, String data) {
        return HttpSync.execResultWithString(url, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static String post(String url, Map<String, String> headers, String data) {
        return HttpSync.execResultWithString(url, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static String post(String url, String data, String contentType) {
        return HttpSync.execResultWithString(url, HttpSync.postRequest(url, null, data, contentType));
    }

    public static String post(String url, Map<String, String> headers, String data, String contentType) {
        return HttpSync.execResultWithString(url, HttpSync.postRequest(url, headers, data, contentType));
    }

    private static String execResultWithString(String url, Request request) {
        try {
            Response response = HttpSync.execResultWithResponse(url, request);
            if (null == response) {
                return null;
            }
            String str = null;
            if (Objects.nonNull(response.body())) {
                str = response.body().string();
                response.body().close();
            }
            return str;
        }
        catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", new Object[]{request.url().uri().toString(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    public static byte[] getWithReturnBytes(String url) {
        return HttpSync.execResultWithBytes(url, HttpSync.getRequest(url, null));
    }

    public static byte[] getWithReturnBytes(String url, Map<String, String> headers) {
        return HttpSync.execResultWithBytes(url, HttpSync.getRequest(url, headers));
    }

    public static byte[] post(String url, byte[] data) {
        return HttpSync.execResultWithBytes(url, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static byte[] post(String url, Map<String, String> headers, byte[] data) {
        return HttpSync.execResultWithBytes(url, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static byte[] post(String url, byte[] data, String contentType) {
        return HttpSync.post(url, null, data, contentType);
    }

    public static byte[] post(String url, Map<String, String> headers, byte[] data, String contentType) {
        return HttpSync.execResultWithBytes(url, HttpSync.postRequest(url, headers, data, contentType));
    }

    private static byte[] execResultWithBytes(String url, Request request) {
        try {
            Response response = HttpSync.execResultWithResponse(url, request);
            if (null == response) {
                return null;
            }
            byte[] bytes = null;
            if (Objects.nonNull(response.body())) {
                bytes = response.body().bytes();
                response.body().close();
            }
            return bytes;
        }
        catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", new Object[]{request.url().uri().toString(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    public static Response getWithReturnResponse(String url) {
        return HttpSync.getWithReturnResponse(url, null);
    }

    public static Response getWithReturnResponse(String url, Map<String, String> headers) {
        return HttpSync.execResultWithResponse(url, HttpSync.getRequest(url, headers));
    }

    public static Response postWithReturnResponse(String url, String data) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, String data) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(String url, String data, String contentType) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, String data, String contentType) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, headers, data, contentType));
    }

    public static Response postWithReturnResponse(String url, byte[] data) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, byte[] data) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(String url, byte[] data, String contentType) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, byte[] data, String contentType) {
        return HttpSync.execResultWithResponse(url, HttpSync.postRequest(url, headers, data, contentType));
    }

    private static Response execResultWithResponse(String url, Request request) {
        return HttpSync.execResultWithResponse(HttpSync.client(url), request);
    }

    public static String get(OkHttpClient client, String url) {
        return HttpSync.execResultWithString(client, HttpSync.getRequest(url, null));
    }

    public static String get(OkHttpClient client, String url, Map<String, String> headers) {
        return HttpSync.execResultWithString(client, HttpSync.getRequest(url, headers));
    }

    public static String post(OkHttpClient client, String url, String data) {
        return HttpSync.execResultWithString(client, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static String post(OkHttpClient client, String url, Map<String, String> headers, String data) {
        return HttpSync.execResultWithString(client, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static String post(OkHttpClient client, String url, String data, String contentType) {
        return HttpSync.execResultWithString(client, HttpSync.postRequest(url, null, data, contentType));
    }

    public static String post(OkHttpClient client, String url, Map<String, String> headers, String data, String contentType) {
        return HttpSync.execResultWithString(client, HttpSync.postRequest(url, headers, data, contentType));
    }

    private static String execResultWithString(OkHttpClient client, Request request) {
        try {
            Response response = HttpSync.execResultWithResponse(client, request);
            if (null == response) {
                return null;
            }
            String str = null;
            if (Objects.nonNull(response.body())) {
                str = response.body().string();
                response.body().close();
            }
            return str;
        }
        catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", new Object[]{request.url().uri().toString(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    public static byte[] getWithReturnBytes(OkHttpClient client, String url) {
        return HttpSync.execResultWithBytes(client, HttpSync.getRequest(url, null));
    }

    public static byte[] getWithReturnBytes(OkHttpClient client, String url, Map<String, String> headers) {
        return HttpSync.execResultWithBytes(client, HttpSync.getRequest(url, headers));
    }

    public static byte[] post(OkHttpClient client, String url, byte[] data) {
        return HttpSync.execResultWithBytes(client, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static byte[] post(OkHttpClient client, String url, Map<String, String> headers, byte[] data) {
        return HttpSync.execResultWithBytes(client, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static byte[] post(OkHttpClient client, String url, byte[] data, String contentType) {
        return HttpSync.execResultWithBytes(client, HttpSync.postRequest(url, null, data, contentType));
    }

    public static byte[] post(OkHttpClient client, String url, Map<String, String> headers, byte[] data, String contentType) {
        return HttpSync.execResultWithBytes(client, HttpSync.postRequest(url, headers, data, contentType));
    }

    private static byte[] execResultWithBytes(OkHttpClient client, Request request) {
        try {
            Response response = HttpSync.execResultWithResponse(client, request);
            if (null == response) {
                return null;
            }
            byte[] bytes = null;
            if (Objects.nonNull(response.body())) {
                bytes = response.body().bytes();
                response.body().close();
            }
            return bytes;
        }
        catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", new Object[]{request.url().uri().toString(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
    }

    public static Response getWithReturnResponse(OkHttpClient client, String url) {
        return HttpSync.execResultWithResponse(client, HttpSync.getRequest(url, null));
    }

    public static Response getWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers) {
        return HttpSync.execResultWithResponse(client, HttpSync.getRequest(url, headers));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, String data) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, String data) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, String data, String contentType) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, String data, String contentType) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, headers, data, contentType));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, byte[] data) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, null, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, byte[] data) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, headers, data, "application/json;charset=UTF-8"));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, byte[] data, String contentType) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, byte[] data, String contentType) {
        return HttpSync.execResultWithResponse(client, HttpSync.postRequest(url, headers, data, contentType));
    }

    public static Response method(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, byte[] data, String contentType) {
        return HttpSync.execResultWithResponse(client, HttpSync.XRequest(url, httpMethod, headers, data, contentType));
    }

    public static Response methodByBody(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, RequestBody body, String contentType) {
        return HttpSync.execResultWithResponse(client, HttpSync.XRequest(url, httpMethod, headers, body, contentType));
    }

    private static Response execResultWithResponse(OkHttpClient client, Request request) {
        int size = GLOBAL_HOOKS.size();
        Response response = null;
        try {
            int idx;
            for (idx = 0; idx < size; ++idx) {
                response = ((HttpHook)GLOBAL_HOOKS.get(idx)).beforeRequest(request);
                if (!Objects.nonNull(response)) continue;
                Response response2 = response;
                return response2;
            }
            response = HttpSync.getHeaderHttpHookInvoker().invoke(request, () -> client.newCall(request).execute());
            for (idx = 0; idx < size; ++idx) {
                ((HttpHook)GLOBAL_HOOKS.get(idx)).afterRequest(request, response);
            }
            Response idx2 = response;
            return idx2;
        }
        catch (Throwable e) {
            logger.error("cusc uri: {} ex: {} ", new Object[]{request.url().uri().toString(), e.getMessage(), e});
            throw new RuntimeException(e);
        }
        finally {
            for (int idx = size - 1; idx >= 0; --idx) {
                ((HttpHook)GLOBAL_HOOKS.get(idx)).completion(request);
            }
        }
    }

    private HttpSync() {
    }
}

