/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.http.client;

import com.cusc.nirvana.common.http.client.HttpBase;
import com.cusc.nirvana.common.http.client.HttpMethod;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAsync
extends HttpBase {
    static final Logger logger = LoggerFactory.getLogger(HttpAsync.class);
    static final Callback DEFAULT_CALLBACK = new Callback(){

        public void onFailure(Call call, IOException e) {
            logger.error("cusc-tools HttpAsync failure default log url:{} msg:{}", new Object[]{call.request().url().toString(), e.getMessage(), e});
        }

        public void onResponse(Call call, Response response) {
            if (logger.isDebugEnabled()) {
                logger.info("cusc HttpAsync success default log url:{} msg:{}", (Object)call.request().url().toString());
            }
        }
    };

    public static void get(String url, Callback cb) {
        HttpAsync.exec(url, HttpAsync.getRequest(url, null), cb);
    }

    public static void get(String url, Map<String, String> headers, Callback cb) {
        HttpAsync.exec(url, HttpAsync.getRequest(url, headers), cb);
    }

    public static void postByJson(String url, String data, Callback cb) {
        HttpAsync.post(url, data, "application/json;charset=UTF-8", cb);
    }

    public static void postByJson(String url, Map<String, String> headers, String data, Callback cb) {
        HttpAsync.post(url, headers, data, "application/json;charset=UTF-8", cb);
    }

    public static void post(String url, String data, String contentType, Callback cb) {
        HttpAsync.exec(url, HttpAsync.postRequest(url, null, data, contentType), cb);
    }

    public static void post(String url, Map<String, String> headers, String data, String contentType, Callback cb) {
        HttpAsync.exec(url, HttpAsync.postRequest(url, headers, data, contentType), cb);
    }

    public static void postByJson(String url, byte[] data, Callback cb) {
        HttpAsync.post(url, data, "application/json;charset=UTF-8", cb);
    }

    public static void postByJson(String url, Map<String, String> headers, byte[] data, Callback cb) {
        HttpAsync.post(url, headers, data, "application/json;charset=UTF-8", cb);
    }

    public static void post(String url, byte[] data, String contentType, Callback cb) {
        HttpAsync.exec(url, HttpAsync.postRequest(url, null, data, contentType), cb);
    }

    public static void post(String url, Map<String, String> headers, byte[] data, String contentType, Callback cb) {
        HttpAsync.exec(url, HttpAsync.postRequest(url, headers, data, contentType), cb);
    }

    private static void exec(String url, Request request, Callback cb) {
        HttpAsync.exec(HttpAsync.client(url), request, cb);
    }

    public static void get(OkHttpClient client, String url, Callback cb) {
        HttpAsync.exec(client, HttpAsync.getRequest(url, null), cb);
    }

    public static void get(OkHttpClient client, String url, Map<String, String> headers, Callback cb) {
        HttpAsync.exec(client, HttpAsync.getRequest(url, headers), cb);
    }

    public static void postByJson(OkHttpClient client, String url, String data, Callback cb) {
        HttpAsync.post(client, url, data, "application/json;charset=UTF-8", cb);
    }

    public static void postByJson(OkHttpClient client, String url, Map<String, String> headers, String data, Callback cb) {
        HttpAsync.post(client, url, headers, data, "application/json;charset=UTF-8", cb);
    }

    public static void post(OkHttpClient client, String url, String data, String contentType, Callback cb) {
        HttpAsync.exec(client, HttpAsync.postRequest(url, null, data, contentType), cb);
    }

    public static void post(OkHttpClient client, String url, Map<String, String> headers, String data, String contentType, Callback cb) {
        HttpAsync.exec(client, HttpAsync.postRequest(url, headers, data, contentType), cb);
    }

    public static void postByJson(OkHttpClient client, String url, byte[] data, Callback cb) {
        HttpAsync.post(client, url, data, "application/json;charset=UTF-8", cb);
    }

    public static void postByJson(OkHttpClient client, String url, Map<String, String> headers, byte[] data, Callback cb) {
        HttpAsync.post(client, url, headers, data, "application/json;charset=UTF-8", cb);
    }

    public static void post(OkHttpClient client, String url, byte[] data, String contentType, Callback cb) {
        HttpAsync.exec(client, HttpAsync.postRequest(url, null, data, contentType), cb);
    }

    public static void post(OkHttpClient client, String url, Map<String, String> headers, byte[] data, String contentType, Callback cb) {
        HttpAsync.exec(client, HttpAsync.postRequest(url, headers, data, contentType), cb);
    }

    public static void method(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, byte[] data, String contentType, Callback cb) {
        HttpAsync.exec(client, HttpAsync.XRequest(url, httpMethod, headers, data, contentType), cb);
    }

    public static void methodByBody(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, RequestBody body, String contentType, Callback cb) {
        HttpAsync.exec(client, HttpAsync.XRequest(url, httpMethod, headers, body, contentType), cb);
    }

    private static void exec(OkHttpClient client, Request request, Callback cb) {
        Call call = client.newCall(request);
        call.enqueue(null == cb ? DEFAULT_CALLBACK : cb);
    }

    private HttpAsync() {
    }
}

