/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt.aes;

import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractAES {
    protected static final int IV_LEN = 16;
    protected static final String DEFAULT_IV = "NLRUZyE8lX2K3ABC";
    protected byte[] key;
    protected String iv = "NLRUZyE8lX2K3ABC";
    protected IvParameterSpec ivSpec;
    protected SecretKeySpec keySpec;
    protected Cipher cipher;

    protected final void setSecretKey(byte[] passwd, boolean useKeyGenerator, SecretLevel level) throws Exception {
        AbstractAES.checkKeyLen(passwd);
        this.key = passwd;
        this.keySpec = useKeyGenerator ? AbstractAES.newSecretKeySpec(this.key, level) : AbstractAES.newSecretKeySpec(this.key);
    }

    protected static final SecretKeySpec newSecretKeySpec(byte[] passwd) throws Exception {
        return new SecretKeySpec(passwd, "AES");
    }

    protected static final SecretKeySpec newSecretKeySpec(byte[] passwd, SecretLevel level) throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(level.level, new SecureRandom(passwd));
        SecretKey secretKey = keyGen.generateKey();
        byte[] bytes = secretKey.getEncoded();
        return new SecretKeySpec(bytes, "AES");
    }

    protected static final IvParameterSpec newIvParameterSpec(String iv) throws Exception {
        return new IvParameterSpec(iv.getBytes("UTF-8"));
    }

    protected static final String padString(String source) {
        char paddingChar = '\u0000';
        int size = 16;
        int x = source.length() % size;
        int padLength = size - x;
        for (int i = 0; i < padLength; ++i) {
            source = source + paddingChar;
        }
        return source;
    }

    protected static final String removeTrailingZeroes(byte[] decrypted) throws Exception {
        if (decrypted.length > 0) {
            int trim = 0;
            for (int i = decrypted.length - 1; i >= 0; --i) {
                if (decrypted[i] != 0) continue;
                ++trim;
            }
            if (trim > 0) {
                byte[] newArray = new byte[decrypted.length - trim];
                System.arraycopy(decrypted, 0, newArray, 0, decrypted.length - trim);
                decrypted = newArray;
            }
        }
        return new String(decrypted, "UTF-8");
    }

    public static final String encodeBase64(byte[] buffer) {
        return Base64.encodeBase64String((byte[])buffer);
    }

    public static final byte[] decodeBase64(String input) {
        return Base64.decodeBase64((String)input);
    }

    public abstract String encrypt(String var1) throws Exception;

    public abstract String decrypt(String var1) throws Exception;

    protected static final void checkViLen(String iv0) throws Exception {
        if (iv0.length() != 16) {
            throw new Exception("IV length must 16");
        }
    }

    protected static final void checkKeyLen(byte[] passwd) throws Exception {
        if (passwd.length != 16 && passwd.length != 24 && passwd.length != 32) {
            throw new Exception("Key length must in {16, 24, 32}");
        }
    }

    public static enum SecretLevel {
        AES128(128),
        AES192(192),
        AES256(256);

        int level = 128;

        private SecretLevel(int level) {
            this.level = level;
        }
    }
}

