/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSA {
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    public static final String UTF8 = "UTF-8";

    public static String sign(String content, String privateKey) {
        return RSA.sign(content, privateKey, UTF8);
    }

    public static String sign(String content, String privateKey, String inputCharset) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyFactory.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(inputCharset));
            byte[] signed = signature.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            throw new RuntimeException("RSA sign:" + e.getMessage());
        }
    }

    public static boolean verify(String content, String sign, String publicKey) {
        return RSA.verify(content, sign, publicKey, UTF8);
    }

    public static boolean verify(String content, String sign, String publicKey, String inputCharset) {
        try {
            byte[] decoded = Base64.decodeBase64((String)publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(inputCharset));
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            throw new RuntimeException("RSA verify:" + e.getMessage());
        }
    }

    public static String encryptByPublicKey(String content, String publicKey) {
        return RSA.encryptByPublicKey(content, publicKey, UTF8);
    }

    public static String encryptByPublicKey(String content, String publicKey, String inputCharset) {
        try {
            byte[] decoded = Base64.decodeBase64((String)publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            String outStr = Base64.encodeBase64String((byte[])cipher.doFinal(content.getBytes(inputCharset)));
            return outStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("[RSA encrypt1] " + ex.getMessage());
        }
    }

    public static String encryptByPrivateKey(String content, String privateKey) {
        return RSA.encryptByPrivateKey(content, privateKey, UTF8);
    }

    public static String encryptByPrivateKey(String content, String privateKey, String inputCharset) {
        try {
            byte[] decoded = Base64.decodeBase64((String)privateKey);
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, priKey);
            String outStr = Base64.encodeBase64String((byte[])cipher.doFinal(content.getBytes(inputCharset)));
            return outStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("[RSA decrypt2] " + ex.getMessage());
        }
    }

    public static String decryptByPrivateKey(String content, String privateKey) {
        return RSA.decryptByPrivateKey(content, privateKey, UTF8);
    }

    public static String decryptByPrivateKey(String content, String privateKey, String inputCharset) {
        try {
            byte[] decoded = Base64.decodeBase64((String)privateKey);
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            byte[] inputByte = Base64.decodeBase64((byte[])content.getBytes(inputCharset));
            String outStr = new String(cipher.doFinal(inputByte));
            return outStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("[RSA decrypt1] " + ex.getMessage());
        }
    }

    public static String decryptByPublicKey(String content, String publicKey) {
        return RSA.decryptByPublicKey(content, publicKey, UTF8);
    }

    public static String decryptByPublicKey(String content, String publicKey, String inputCharset) {
        try {
            byte[] decoded = Base64.decodeBase64((String)publicKey);
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, pubKey);
            byte[] inputByte = Base64.decodeBase64((byte[])content.getBytes(inputCharset));
            String outStr = new String(cipher.doFinal(inputByte));
            return outStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("[RSA encrypt2] " + ex.getMessage());
        }
    }

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }
}

