package com.cusc.nirvana.common.uid;

import org.apache.commons.lang3.StringUtils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.*;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author jeff.chen
 * @file UtilTools
 * @E-mail chenjf159@chinaunicom.cn
 */

public class UtilTools {

    private UtilTools() {
    }

    private static String IP_ADDRESS = "";

    private static int PROCESS_ID = 0;

    private static String STR_PROCESS_ID = "N/A";

    /**
     * 获取当前服务进程号
     *
     * @return processID
     */
    public static final int getProcessID() {
        if (PROCESS_ID > 0) {
            return PROCESS_ID;
        }

        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();

        PROCESS_ID = Integer.parseInt(runtimeMXBean.getName().split("@")[0]);

        STR_PROCESS_ID = String.valueOf(PROCESS_ID);

        return PROCESS_ID;
    }

    public static final String getStrProcessID() {
        if (PROCESS_ID > 0) {
            return STR_PROCESS_ID;
        }

        getProcessID();

        return STR_PROCESS_ID;
    }

    /**
     * 注：字符串 不包含 PRE_FILL = 'O'
     */
    private static char[] charSet32 = "0123456789ABCDEFGHJKLMNPQRSTUVWX".toCharArray();

    /**
     * 固定长度: 32进制，前缀补位用
     */
    static final char PRE_FILL = 'O';

    static final int BIT_5 = 5;
    static final int VAL_31 = (1 << BIT_5) - 1;

    public static String base10ToBase32String(long idx) {
        StringBuilder stringBuilder = new StringBuilder();

        long val = idx;

        while (val != 0) {
            // 顺序：高位在前,低位在后
            stringBuilder.append(charSet32[(int) (val & VAL_31)]);
            val = val >> BIT_5;
        }

        return stringBuilder.toString();
    }

    public static long base32String2Base10Long(String base32String) {
        String str = trim(base32String);
        long base10 = 0;
        int length = str.length();
        for (int i = length - 1; i >= 0; i--) {
            base10 = base10 << BIT_5;
            char ch = str.charAt(i);

            for (int j = 0; j < charSet32.length; j++) {
                if (ch == charSet32[j]) {
                    base10 ^= j;
                    break;
                }
            }
        }

        return base10;
    }

    public static String getLocalMac() {
        InetAddress local = getInetAddress();

        try {
            return byte2String(NetworkInterface.getByInetAddress(local).getHardwareAddress());
        } catch (SocketException e) {
            throw new IllegalStateException("获取本地MAC地址失败", e);
        }
    }

    public static String reverse2Mac(String base32MacString) {
        long mac = UtilTools.base32String2Base10Long(base32MacString);

        StringJoiner stringJoiner = new StringJoiner(":");

        String hexStr = Long.toHexString(mac);
        for (int idx = 0; idx < hexStr.length(); idx += 2) {
            String bitHex = hexStr.substring(idx, idx + 2);
            stringJoiner.add(bitHex.toUpperCase());
        }

        return stringJoiner.toString();
    }

    public static String getLocalIP() {
        InetAddress local = getInetAddress();

        return byte2String(local.getAddress());
    }

    public static InetAddress getCurrentIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> enumerationInetAddress = networkInterface.getInetAddresses();
                while (enumerationInetAddress.hasMoreElements()) {
                    InetAddress inetAddress = enumerationInetAddress.nextElement();
                    if (!inetAddress.isLinkLocalAddress()
                            && !inetAddress.isLoopbackAddress()
                            && inetAddress instanceof Inet4Address) {
                        return inetAddress;
                    }
                }
            }
        } catch (SocketException e) {
            throw new IllegalStateException("获取本地IP地址失败 getCurrentIp()", e);
        }

        throw new IllegalStateException("获取本地IP地址失败 匹配到0个可用IP");
    }

    public static String getHostAddress() {
        if (StringUtils.isNotBlank(IP_ADDRESS)) {
            return IP_ADDRESS;
        }

        InetAddress local = getInetAddress();

        IP_ADDRESS = local.getHostAddress();

        return IP_ADDRESS;
    }

    private static InetAddress getInetAddress() {
        InetAddress local;
        try {
            local = InetAddress.getLocalHost();
        } catch (UnknownHostException e) {
            local = getCurrentIp();
            // throw new IllegalStateException("获取本地IP地址失败", e);
        }

        return local;
    }

    public static String reverse2IP(String base32IPString) {

        long address = UtilTools.base32String2Base10Long(base32IPString);

        StringJoiner stringJoiner = new StringJoiner(".");

        String hexStr = Long.toHexString(address);

        if (1 == (hexStr.length() % 2)) {
            hexStr = "0" + hexStr;
        }

        for (int idx = 0; idx < hexStr.length(); idx += 2) {
            String bitHex = hexStr.substring(idx, idx + 2);
            stringJoiner.add(String.valueOf(Integer.parseInt(bitHex, 16)));
        }

        return stringJoiner.toString();
    }

    private static String byte2String(byte[] bytes) {
        // 地址默认10位
        return byte2String(bytes, 10);
    }

    private static String byte2String(byte[] bytes, int fixedLen) {
        StringBuilder stringBuilder = new StringBuilder();

        for (int i = 0; i < bytes.length; i++) {
            int temp = bytes[i] & 0xFF;
            if (temp > 0xF) {
                stringBuilder.append(Integer.toHexString(temp));
            } else {
                stringBuilder.append(0);
                stringBuilder.append(Integer.toHexString(temp));
            }
        }

        long val1 = Long.parseLong(stringBuilder.toString(), 16);

        String base32Str = UtilTools.base10ToBase32String(val1);

        return appendPrefixWithFixedLength(base32Str, fixedLen);
    }

    public static String appendPrefixWithFixedLength(String base32Str, int fixedLen) {
        return appendPrefixWithFixedLength(PRE_FILL, base32Str, fixedLen);
    }

    public static String appendPrefixWithFixedLength(char fill, String base32Str, int fixedLen) {
        int len = base32Str.length();

        if (len < fixedLen) {
            StringBuilder prefix = new StringBuilder();

            for (int i = 0; i < (fixedLen - len); i++) {
                prefix.append(fill);
            }

            return prefix.append(base32Str).toString();
        } else if (len > fixedLen) {
            throw new IllegalStateException("字符串超长");
        }

        return base32Str;
    }

    private static String trim(String base32IPString) {
        int startIndex = 0;
        for (int i = 0; i < base32IPString.length(); i++) {
            if (PRE_FILL != base32IPString.charAt(i)) {
                break;
            }
            startIndex += 1;
        }

        return (0 == startIndex) ? base32IPString : base32IPString.substring(startIndex);
    }

    /**
     * base:32字符串
     *
     * @param length 字符串长度
     * @return
     */
    public static String fixedLengthRandomHexString(int length) {
        if (length <= 0) {
            length = 1;
        }

        ThreadLocalRandom random = ThreadLocalRandom.current();

        StringBuilder stringBuilder = new StringBuilder();

        for (int i = 0; i < length; i++) {
            stringBuilder.append(charSet32[random.nextInt(32)]);
        }

        return stringBuilder.toString();
    }

}
