package com.cusc.nirvana.common.uid;

import java.util.StringJoiner;

/**
 * @author jeff.chen
 * @file UID
 * @E-mail chenjf159@chinaunicom.cn
 */
public interface UID {

    /**
     * get UniqueID
     *
     * @return UniqueID
     */
    String ID();

    /**
     * 解析UID
     * {address-10}{process-id-5}{timeOfMillis-9}{sequence-5}{clock-callback-3}
     *
     * @param uniqueID
     * @return
     */
    default String reverse(String uniqueID) {
        StringJoiner stringJoiner = new StringJoiner("-");

        if (UtilTools.PRE_FILL == uniqueID.charAt(0)) {
            // UID 类型判断, 可能存在BUG.
            String address = UtilTools.reverse2IP(uniqueID.substring(0, 10));
            stringJoiner.add(address);
        } else {
            String address = UtilTools.reverse2Mac(uniqueID.substring(0, 10));
            stringJoiner.add(address);
        }

        stringJoiner.add(uniqueID.substring(10, 15));

        long timeOfMillis = UtilTools.base32String2Base10Long(uniqueID.substring(15, 24));
        stringJoiner.add(String.valueOf(timeOfMillis));

        long sequence = UtilTools.base32String2Base10Long(uniqueID.substring(24, 29));
        stringJoiner.add(String.valueOf(sequence));

        long clock = UtilTools.base32String2Base10Long(uniqueID.substring(29));
        stringJoiner.add(String.valueOf(clock));

        return stringJoiner.toString();
    }

    default String reverse(String uniqueID, Mode mode) {
        switch (mode) {
            case ADDRESS:
                if (UtilTools.PRE_FILL == uniqueID.charAt(0)) {
                    // UID 类型判断, 可能存在BUG.
                    return UtilTools.reverse2IP(uniqueID.substring(0, 10));
                } else {
                    return UtilTools.reverse2Mac(uniqueID.substring(0, 10));
                }
            case PROCESS_ID:
                return uniqueID.substring(10, 15);
            case CTIME:
                return String.valueOf(UtilTools.base32String2Base10Long(uniqueID.substring(15, 24)));
            case SEQUENCE:
                return String.valueOf(UtilTools.base32String2Base10Long(uniqueID.substring(24, 29)));
            case CALLBACKS:
                return String.valueOf(UtilTools.base32String2Base10Long(uniqueID.substring(29)));
            default:
                throw new IllegalArgumentException("UID 无效Mode入参");
        }
    }

    /**
     * 方便测试阶段，进行时钟回拨
     *
     * @return
     */
    default long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    enum Mode {
        /**
         * ADDRESS
         */
        ADDRESS,
        /**
         * PROCESS_ID
         */
        PROCESS_ID,
        /**
         * CTIME
         */
        CTIME,
        /**
         * SEQUENCE
         */
        SEQUENCE,
        /**
         * CALLBACKS
         */
        CALLBACKS;
    }

}
