package com.cusc.nirvana.common.tool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.*;

/**
 * 通过文件获取中间件组件版本信息
 *
 * @author jeff.chen
 * @file VersionUtil
 * @E-mail chenjf159@chinaunicom.cn
 */
public class VersionUtil {

    private final static Logger logger = LoggerFactory.getLogger(VersionUtil.class);

    /**
     * 获取中间件版本信息
     *
     * @param fileName
     * @return
     */
    public static List<Map<String, String>> loadFile(String fileName, ClassLoader classLoader) {
        List<Map<String, String>> list = new ArrayList<>();
        try {
            Enumeration<URL> urls;
            if (classLoader != null) {
                urls = classLoader.getResources(fileName);
            } else {
                urls = ClassLoader.getSystemResources(fileName);
            }

            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Map<String, String> map = new HashMap<>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    final int ci = line.indexOf("#");
                    if (ci >= 0) {
                        line = line.substring(0, ci);
                    }
                    line = line.trim();
                    if (line.length() > 0) {
                        String name = null;
                        int i = line.indexOf(":");
                        if (i > 0) {
                            // 解析文件的键值对，name等于key， line等于value
                            name = line.substring(0, i).trim();
                            if (!"Cusc-Project-Parent".equals(name)
                                    && !"Cusc-Project-Version".equals(name)
                                    && !"Implementation-Title".equals(name)
                                    && !"Implementation-Version".equals(name)) {
                                continue;
                            }
                            line = line.substring(i + 1).trim();
                            map.put(name, line);
                        }
                    }
                }
                if (map.get("Cusc-Project-Parent") == null) {
                    continue;
                }
                if (map.size() > 0) {
                    list.add(map);
                }
            }
        } catch (Exception e) {
            logger.error("解析中间件版本信息失败，原因：", e);
        }
        return list;
    }

}
