package com.cusc.nirvana.common.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author jeff
 * @file NamedThreadFactory
 * @E-mail chenjf159@chinaunicom.cn
 */

public class NamedThreadFactory implements ThreadFactory {

    private final AtomicInteger mThreadNum = new AtomicInteger(1);

    private final String mPrefix;

    private final boolean mDaemon;

    private final ThreadGroup mGroup;

    private int newPriority = Thread.NORM_PRIORITY;

    public NamedThreadFactory() {
        this("default-pool", true);
    }

    public NamedThreadFactory(String prefix) {
        this(prefix, true);
    }

    public NamedThreadFactory(String prefix, int newPriority) {
        this(prefix, true, newPriority);
    }

    public NamedThreadFactory(String prefix, boolean daemon) {
        this.mPrefix = prefix;
        this.mDaemon = daemon;
        SecurityManager s = System.getSecurityManager();
        mGroup = (s == null) ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    public NamedThreadFactory(String prefix, boolean daemon, int newPriority) {
        this.mPrefix = prefix;
        this.mDaemon = daemon;
        this.newPriority = newPriority;
        SecurityManager s = System.getSecurityManager();
        mGroup = (s == null) ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = mPrefix + "-" + mThreadNum.getAndIncrement();

        Thread newThread = new Thread(mGroup, runnable, name, 0);
        newThread.setDaemon(mDaemon);

        if (Thread.NORM_PRIORITY != newPriority) {
            newThread.setPriority(newPriority);
        }

        return newThread;
    }

    public String getPrefix() {
        return mPrefix;
    }

}
