package com.cusc.nirvana.common.result;

import java.util.ArrayList;
import java.util.List;

/**
 * 分页工具类
 *
 * @author jeff.chen
 * @file PageResult
 * @E-mail chenjf159@chinaunicom.cn
 */
public class PageResult<T> {

    private static final long serialVersionUID = 1L;

    /**
     * 总记录数
     */
    private long totalCount;

    /**
     * 每页记录数
     */
    private long pageSize;

    /**
     * 当前页数
     */
    private long currPage;

    /**
     * 列表数据
     */
    private List<T> list;

    /**
     * 是否有下一页
     */
    private boolean hasMore;

    public PageResult() {
        super();
    }

    /**
     * 分页
     *
     * @param list       列表数据
     * @param totalCount 总记录数
     * @param pageSize   每页记录数
     * @param currPage   当前页数
     */
    public PageResult(List<T> list, long totalCount, long pageSize, long currPage) {
        this.list = list;
        this.totalCount = totalCount;
        this.pageSize = pageSize;
        this.currPage = currPage;
    }

    public PageResult(List<T> list, long totalCount, long pageSize) {
        this.list = list;
        this.totalCount = totalCount;
        this.pageSize = pageSize;
    }

    public PageResult(long currPage, long pageSize) {
        this.currPage = currPage;
        this.pageSize = pageSize;
    }

    public static PageResult createError(String msg) {
        PageResult page = new PageResult();

        return page;
    }

    public long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getPageSize() {
        return pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public long getCurrPage() {
        return currPage;
    }

    public void setCurrPage(long currPage) {
        this.currPage = currPage;
    }

    public List<T> getList() {
        //if (CollectionUtils.isEmpty(list)) {
        if (list == null || list.isEmpty()) {
            this.list = new ArrayList<>(0);
        }
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public boolean isHasMore() {
        if (totalCount - (currPage * pageSize) > 0) {
            this.hasMore = true;
        } else {
            this.hasMore = false;
        }
        return hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }
}
