
package com.cusc.nirvana.common.loader;

import com.cusc.nirvana.common.evn.EnvHelper;

import java.lang.annotation.*;

/**
 * The interface Load level.
 *
 * @author alibaba-inc.com
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface LoadLevel {

    /**
     * Name string.
     *
     * @return the string
     */
    String name();

    /**
     * Order int.
     * 排序：从小到大
     *
     * @return the int
     */
    int order() default 0;

    /**
     * allow load max-env
     *
     * @return
     */
    EnvHelper.RtEnv activateEnv() default EnvHelper.RtEnv.ignore;

}
