package com.cusc.nirvana.common.http.client;

import com.cusc.nirvana.common.Callback;
import okhttp3.Request;
import okhttp3.Response;

/**
 * @author jeff.chen
 * @file HttpHook
 * @E-mail chenjf159@chinaunicom.cn
 */
public abstract class AbstractHttpInvokerHandler {

    private AbstractHttpInvokerHandler next;

    public AbstractHttpInvokerHandler getNext() {
        return next;
    }

    public void setNext(AbstractHttpInvokerHandler next) {
        this.next = next;
    }

    /**
     * invoke
     *
     * @param request
     * @param callback
     * @return Response if not null will return
     * @throws Throwable
     */
    public abstract Response invoke(Request request, Callback<Response> callback) throws Throwable;

}
