/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.tool;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger logger = LoggerFactory.getLogger(VersionUtil.class);

    public static List<Map<String, String>> loadFile(String fileName, ClassLoader classLoader) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                HashMap<String, String> map = new HashMap<String, String>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int ci = line.indexOf("#");
                    if (ci >= 0) {
                        line = line.substring(0, ci);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    String name = null;
                    int i = line.indexOf(":");
                    if (i <= 0 || !"Cusc-Project-Parent".equals(name = line.substring(0, i).trim()) && !"Cusc-Project-Version".equals(name) && !"Implementation-Title".equals(name) && !"Implementation-Version".equals(name)) continue;
                    line = line.substring(i + 1).trim();
                    map.put(name, line);
                }
                if (map.get("Cusc-Project-Parent") == null || map.size() <= 0) continue;
                list.add(map);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4e2d\u95f4\u4ef6\u7248\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
        return list;
    }
}

