/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.tool;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class TimeOutWatch {
    private final Instant startTime;
    private long timeout;
    private Clock clock;

    TimeOutWatch(Clock clock, long timeout) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.timeout = timeout;
    }

    public static TimeOutWatch start(long timeout) {
        return new TimeOutWatch(Clock.systemUTC(), timeout);
    }

    public Duration cost() {
        return Duration.between(this.startTime, this.clock.instant());
    }

    public boolean isTimeout() {
        if (this.timeout > 0L) {
            return Duration.between(this.startTime, this.clock.instant()).toMillis() > this.timeout;
        }
        return false;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

