/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.tool;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.concurrent.locks.LockSupport;

public class CustomRateLimiter {
    private static final int DEFAULT_RATE = 1000;
    RateLimiter rateLimiter;
    private static final long NANO_TIME_START = System.nanoTime();

    public CustomRateLimiter(String name) {
        this.rateLimiter = this.of(name, null);
    }

    public CustomRateLimiter(String name, int rate) {
        this.rateLimiter = this.of(name, this.getRateLimiterConfig(rate, 0L));
    }

    public CustomRateLimiter(String name, int rate, long timeout) {
        this.rateLimiter = this.of(name, this.getRateLimiterConfig(rate, timeout));
    }

    public long reservePermission() {
        return this.rateLimiter.reservePermission();
    }

    public void waitForPermission() {
        long nanosToWait = this.reservePermission();
        if (nanosToWait > 0L) {
            CustomRateLimiter.waitForPermission(nanosToWait);
        } else if (nanosToWait < 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitForPermission();
        }
    }

    public boolean tryPermission() {
        long nanosToWait = this.reservePermission();
        if (nanosToWait < 0L) {
            return false;
        }
        if (nanosToWait > 0L) {
            CustomRateLimiter.waitForPermission(nanosToWait);
        }
        return true;
    }

    private RateLimiterConfig getRateLimiterConfig(int limitForPeriod, long timeout) {
        return RateLimiterConfig.custom().limitForPeriod(limitForPeriod).limitRefreshPeriod(Duration.ofSeconds(1L)).timeoutDuration(Duration.ofSeconds(timeout)).build();
    }

    private RateLimiter of(String name, RateLimiterConfig rateLimiterConfig) {
        if (null == rateLimiterConfig) {
            return RateLimiter.of((String)name, (RateLimiterConfig)this.getRateLimiterConfig(1000, 0L));
        }
        return RateLimiter.of((String)name, (RateLimiterConfig)rateLimiterConfig);
    }

    private static boolean waitForPermission(long nanosToWait) {
        long deadline = CustomRateLimiter.currentNanoTime() + nanosToWait;
        boolean wasInterrupted = false;
        while (CustomRateLimiter.currentNanoTime() < deadline && !wasInterrupted) {
            long sleepBlockDuration = deadline - CustomRateLimiter.currentNanoTime();
            LockSupport.parkNanos(sleepBlockDuration);
            wasInterrupted = Thread.interrupted();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return !wasInterrupted;
    }

    private static long currentNanoTime() {
        return System.nanoTime() - NANO_TIME_START;
    }
}

