/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger mThreadNum = new AtomicInteger(1);
    private final String mPrefix;
    private final boolean mDaemon;
    private final ThreadGroup mGroup;
    private int newPriority = 5;

    public NamedThreadFactory() {
        this("default-pool", true);
    }

    public NamedThreadFactory(String prefix) {
        this(prefix, true);
    }

    public NamedThreadFactory(String prefix, int newPriority) {
        this(prefix, true, newPriority);
    }

    public NamedThreadFactory(String prefix, boolean daemon) {
        this.mPrefix = prefix;
        this.mDaemon = daemon;
        SecurityManager s = System.getSecurityManager();
        this.mGroup = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    public NamedThreadFactory(String prefix, boolean daemon, int newPriority) {
        this.mPrefix = prefix;
        this.mDaemon = daemon;
        this.newPriority = newPriority;
        SecurityManager s = System.getSecurityManager();
        this.mGroup = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.mPrefix + "-" + this.mThreadNum.getAndIncrement();
        Thread newThread = new Thread(this.mGroup, runnable, name, 0L);
        newThread.setDaemon(this.mDaemon);
        if (5 != this.newPriority) {
            newThread.setPriority(this.newPriority);
        }
        return newThread;
    }

    public String getPrefix() {
        return this.mPrefix;
    }
}

