/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.evn;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvHelper {
    Logger logger = LoggerFactory.getLogger(EnvHelper.class);
    final RtEnv currentEnv;

    public boolean match(RtEnv maxEnv) {
        if (RtEnv.reject.equals((Object)this.currentEnv) || RtEnv.ignore.equals((Object)maxEnv)) {
            return false;
        }
        if (RtEnv.allow.equals((Object)this.currentEnv)) {
            return true;
        }
        return maxEnv.getVal() >= this.currentEnv.getVal();
    }

    public RtEnv getCurrentEnv() {
        return this.currentEnv;
    }

    private EnvHelper() {
        String envKey = "env";
        String env = System.getProperty(envKey, "N/A");
        if ("N/A".equals(env)) {
            envKey = "spring.profiles.active";
            env = System.getProperty(envKey, "N/A");
        }
        this.currentEnv = RtEnv.getEnv(env);
        this.logger.info("CUSC \u5f53\u524d\u73af\u5883: key={} value={}", (Object)envKey, (Object)this.currentEnv.name);
    }

    public static EnvHelper getInstance() {
        return SingletonInternal.instance;
    }

    public static enum RtEnv {
        ignore("ignore", 0),
        reject("reject", 0),
        local("local", 111),
        dev("dev", 222),
        test("test", 333),
        exe("exe", 444),
        pst("pst", 555),
        cupre("cu-pre", 666),
        pre("pre", 777),
        prod("prod", 888),
        cuprod("cu-prod", 889),
        allow("allow", 999);

        String name;
        int val;

        private RtEnv(String name, int val) {
            this.name = name;
            this.val = val;
        }

        public String getName() {
            return this.name;
        }

        public int getVal() {
            return this.val;
        }

        public static RtEnv getEnv(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return reject;
            }
            if (allow.getName().equalsIgnoreCase(name)) {
                return allow;
            }
            if (cuprod.getName().equalsIgnoreCase(name)) {
                return cuprod;
            }
            if (prod.getName().equalsIgnoreCase(name)) {
                return prod;
            }
            if (cupre.getName().equalsIgnoreCase(name)) {
                return cupre;
            }
            if (pre.getName().equalsIgnoreCase(name)) {
                return pre;
            }
            if (pst.getName().equalsIgnoreCase(name)) {
                return pst;
            }
            if (exe.getName().equalsIgnoreCase(name)) {
                return exe;
            }
            if (test.getName().equalsIgnoreCase(name)) {
                return test;
            }
            if (dev.getName().equalsIgnoreCase(name)) {
                return dev;
            }
            if (local.getName().equalsIgnoreCase(name)) {
                return local;
            }
            return reject;
        }
    }

    static class SingletonInternal {
        static EnvHelper instance = new EnvHelper();

        SingletonInternal() {
        }
    }
}

