/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt.crc;

public class Modbus485 {
    public static final int CRC16_BIT_WIDTH = 8;
    public static final int CRC16_REGISTER = 65535;
    public static final int CRC16_POLYNOMIALS = 40961;
    public static final int CHECK_LAST_BIT = 1;
    static byte[] CRC16_TAB_H = new byte[]{0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64, 0, -63, -127, 64, 1, -64, -128, 65, 0, -63, -127, 64, 1, -64, -128, 65, 1, -64, -128, 65, 0, -63, -127, 64};
    static byte[] CRC16_TAB_L = new byte[]{0, -64, -63, 1, -61, 3, 2, -62, -58, 6, 7, -57, 5, -59, -60, 4, -52, 12, 13, -51, 15, -49, -50, 14, 10, -54, -53, 11, -55, 9, 8, -56, -40, 24, 25, -39, 27, -37, -38, 26, 30, -34, -33, 31, -35, 29, 28, -36, 20, -44, -43, 21, -41, 23, 22, -42, -46, 18, 19, -45, 17, -47, -48, 16, -16, 48, 49, -15, 51, -13, -14, 50, 54, -10, -9, 55, -11, 53, 52, -12, 60, -4, -3, 61, -1, 63, 62, -2, -6, 58, 59, -5, 57, -7, -8, 56, 40, -24, -23, 41, -21, 43, 42, -22, -18, 46, 47, -17, 45, -19, -20, 44, -28, 36, 37, -27, 39, -25, -26, 38, 34, -30, -29, 35, -31, 33, 32, -32, -96, 96, 97, -95, 99, -93, -94, 98, 102, -90, -89, 103, -91, 101, 100, -92, 108, -84, -83, 109, -81, 111, 110, -82, -86, 106, 107, -85, 105, -87, -88, 104, 120, -72, -71, 121, -69, 123, 122, -70, -66, 126, 127, -65, 125, -67, -68, 124, -76, 116, 117, -75, 119, -73, -74, 118, 114, -78, -77, 115, -79, 113, 112, -80, 80, -112, -111, 81, -109, 83, 82, -110, -106, 86, 87, -105, 85, -107, -108, 84, -100, 92, 93, -99, 95, -97, -98, 94, 90, -102, -101, 91, -103, 89, 88, -104, -120, 72, 73, -119, 75, -117, -118, 74, 78, -114, -113, 79, -115, 77, 76, -116, 68, -124, -123, 69, -121, 71, 70, -122, -126, 66, 67, -125, 65, -127, -128, 64};

    public static final boolean CRC16(byte[] buf, int len) {
        int CRC_Register = 65535;
        for (int i = 0; i < len; ++i) {
            CRC_Register ^= buf[i] & 0xFF;
            int k = 0;
            while (k++ < 8) {
                if ((CRC_Register & 1) == 1) {
                    CRC_Register >>= 1;
                    CRC_Register ^= 0xA001;
                    continue;
                }
                CRC_Register >>= 1;
            }
        }
        int CRC_CODE_HIGH = CRC_Register & 0xFF;
        int CRC_CODE_LOW = CRC_Register >> 8;
        return buf[len] == CRC_CODE_HIGH && buf[len + 1] == CRC_CODE_LOW;
    }

    public static byte[] modbusRtuCrc(byte[] buf, int len) {
        int crc = 65535;
        for (int pos = 0; pos < len; ++pos) {
            crc ^= buf[pos] & 0xFF;
            for (int i = 8; i != 0; --i) {
                if ((crc & 1) != 0) {
                    crc >>= 1;
                    crc ^= 0xA001;
                    continue;
                }
                crc >>= 1;
            }
        }
        String sHexCrc = Integer.toHexString(crc).toUpperCase();
        if (sHexCrc.length() % 2 == 1) {
            sHexCrc = "0" + sHexCrc;
        }
        if (sHexCrc.length() == 2) {
            sHexCrc = "00" + sHexCrc;
        }
        byte[] bResultArray = new byte[2];
        bResultArray[1] = (byte)Integer.parseInt(sHexCrc.substring(0, 2), 16);
        bResultArray[0] = (byte)Integer.parseInt(sHexCrc.substring(2, 4), 16);
        return bResultArray;
    }

    public static int calcCrc16(byte[] data) {
        return Modbus485.calcCrc16(data, 0, data.length);
    }

    public static int calcCrc16(byte[] data, int offset, int len) {
        return Modbus485.calcCrc16(data, offset, len, 65535);
    }

    public static int calcCrc16(byte[] data, int offset, int len, int preval) {
        int ucCRCHi = (preval & 0xFF00) >> 8;
        int ucCRCLo = preval & 0xFF;
        for (int i = 0; i < len; ++i) {
            int iIndex = (ucCRCLo ^ data[offset + i]) & 0xFF;
            ucCRCLo = ucCRCHi ^ CRC16_TAB_H[iIndex];
            ucCRCHi = CRC16_TAB_L[iIndex];
        }
        return (ucCRCHi & 0xFF) << 8 | ucCRCLo & 0xFF & 0xFFFF;
    }
}

