package com.cusc.nirvana.common.tool;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

/**
 * @author jeff.chen
 * @file StopWatch
 * @E-mail chenjf159@chinaunicom.cn
 */
public class TimeOutWatch {

    private final Instant startTime;

    private long timeout;

    private Clock clock;

    TimeOutWatch(Clock clock, long timeout) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.timeout = timeout;
    }

    /**
     * timeout
     *
     * @param timeout millis
     * @return
     */
    public static TimeOutWatch start(long timeout) {
        return new TimeOutWatch(Clock.systemUTC(), timeout);
    }

    public Duration cost() {
        return Duration.between(startTime, clock.instant());
    }

    public boolean isTimeout() {
        if (timeout > 0) {
            return Duration.between(startTime, clock.instant()).toMillis() > timeout;
        }

        return false;
    }

    public long getTimeout() {
        return timeout;
    }

}
