package com.cusc.nirvana.common.http.client;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;

/**
 * demo
 * <p>
 * ConnectionPool pool = new ConnectionPool(5, 5, TimeUnit.MINUTES);
 * OkHttpClient client0 = new OkHttpClient().newBuilder()
 * .connectionPool(pool)
 * .connectTimeout(5, TimeUnit.SECONDS)
 * .writeTimeout(5, TimeUnit.SECONDS)
 * .readTimeout(5, TimeUnit.SECONDS).build();
 *
 * @author jeff.chen
 * @file HttpSync
 * @E-mail chenjf159@chinaunicom.cn
 */
public class HttpSync extends HttpBase {

    final static Logger logger = LoggerFactory.getLogger(HttpSync.class);

    public static String get(String url) {
        return execResultWithString(url, getRequest(url, null));
    }

    public static String get(String url, Map<String, String> headers) {
        return execResultWithString(url, getRequest(url, headers));
    }

    public static String post(String url, String data) {
        return execResultWithString(url, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static String post(String url, Map<String, String> headers, String data) {
        return execResultWithString(url, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static String post(String url, String data, String contentType) {
        return execResultWithString(url, postRequest(url, null, data, contentType));
    }

    public static String post(String url, Map<String, String> headers, String data, String contentType) {
        return execResultWithString(url, postRequest(url, headers, data, contentType));
    }

    private static String execResultWithString(String url, Request request) {
        try {
            Response response = execResultWithResponse(url, request);
            if (null == response) {
                return null;
            }

            String str = null;
            if (Objects.nonNull(response.body())) {
                str = response.body().string();
                response.body().close();
            }

            return str;
        } catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", request.url().uri().toString(), e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] getWithReturnBytes(String url) {
        return execResultWithBytes(url, getRequest(url, null));
    }

    public static byte[] getWithReturnBytes(String url, Map<String, String> headers) {
        return execResultWithBytes(url, getRequest(url, headers));
    }

    public static byte[] post(String url, byte[] data) {
        return execResultWithBytes(url, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static byte[] post(String url, Map<String, String> headers, byte[] data) {
        return execResultWithBytes(url, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static byte[] post(String url, byte[] data, String contentType) {
        return post(url, null, data, contentType);
    }

    public static byte[] post(String url, Map<String, String> headers, byte[] data, String contentType) {
        return execResultWithBytes(url, postRequest(url, headers, data, contentType));
    }

    private static byte[] execResultWithBytes(String url, Request request) {
        try {
            Response response = execResultWithResponse(url, request);
            if (null == response) {
                return null;
            }

            byte[] bytes = null;
            if (Objects.nonNull(response.body())) {
                bytes = response.body().bytes();
                response.body().close();
            }

            return bytes;
        } catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", request.url().uri().toString(), e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static Response getWithReturnResponse(String url) {
        return getWithReturnResponse(url, null);
    }

    public static Response getWithReturnResponse(String url, Map<String, String> headers) {
        return execResultWithResponse(url, getRequest(url, headers));
    }

    public static Response postWithReturnResponse(String url, String data) {
        return execResultWithResponse(url, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, String data) {
        return execResultWithResponse(url, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(String url, String data, String contentType) {
        return execResultWithResponse(url, postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, String data, String contentType) {
        return execResultWithResponse(url, postRequest(url, headers, data, contentType));
    }

    public static Response postWithReturnResponse(String url, byte[] data) {
        return execResultWithResponse(url, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, byte[] data) {
        return execResultWithResponse(url, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(String url, byte[] data, String contentType) {
        return execResultWithResponse(url, postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(String url, Map<String, String> headers, byte[] data, String contentType) {
        return execResultWithResponse(url, postRequest(url, headers, data, contentType));
    }

    private static Response execResultWithResponse(String url, Request request) {
        return execResultWithResponse(client(url), request);
    }

    /**
     * 自定义  OkHttpClient
     */

    public static String get(OkHttpClient client, String url) {
        return execResultWithString(client, getRequest(url, null));
    }

    public static String get(OkHttpClient client, String url, Map<String, String> headers) {
        return execResultWithString(client, getRequest(url, headers));
    }

    public static String post(OkHttpClient client, String url, String data) {
        return execResultWithString(client, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static String post(OkHttpClient client, String url, Map<String, String> headers, String data) {
        return execResultWithString(client, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static String post(OkHttpClient client, String url, String data, String contentType) {
        return execResultWithString(client, postRequest(url, null, data, contentType));
    }

    public static String post(OkHttpClient client, String url, Map<String, String> headers, String data, String contentType) {
        return execResultWithString(client, postRequest(url, headers, data, contentType));
    }

    private static String execResultWithString(OkHttpClient client, Request request) {
        try {
            Response response = execResultWithResponse(client, request);
            if (null == response) {
                return null;
            }

            String str = null;
            if (Objects.nonNull(response.body())) {
                str = response.body().string();
                response.body().close();
            }

            return str;
        } catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", request.url().uri().toString(), e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] getWithReturnBytes(OkHttpClient client, String url) {
        return execResultWithBytes(client, getRequest(url, null));
    }

    public static byte[] getWithReturnBytes(OkHttpClient client, String url, Map<String, String> headers) {
        return execResultWithBytes(client, getRequest(url, headers));
    }

    public static byte[] post(OkHttpClient client, String url, byte[] data) {
        return execResultWithBytes(client, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static byte[] post(OkHttpClient client, String url, Map<String, String> headers, byte[] data) {
        return execResultWithBytes(client, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static byte[] post(OkHttpClient client, String url, byte[] data, String contentType) {
        return execResultWithBytes(client, postRequest(url, null, data, contentType));
    }

    public static byte[] post(OkHttpClient client, String url, Map<String, String> headers, byte[] data, String contentType) {
        return execResultWithBytes(client, postRequest(url, headers, data, contentType));
    }

    private static byte[] execResultWithBytes(OkHttpClient client, Request request) {
        try {
            Response response = execResultWithResponse(client, request);
            if (null == response) {
                return null;
            }

            byte[] bytes = null;
            if (Objects.nonNull(response.body())) {
                bytes = response.body().bytes();
                response.body().close();
            }

            return bytes;
        } catch (IOException e) {
            logger.error("cusc uri: {} ex: {} ", request.url().uri().toString(), e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static Response getWithReturnResponse(OkHttpClient client, String url) {
        return execResultWithResponse(client, getRequest(url, null));
    }

    public static Response getWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers) {
        return execResultWithResponse(client, getRequest(url, headers));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, String data) {
        return execResultWithResponse(client, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, String data) {
        return execResultWithResponse(client, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, String data, String contentType) {
        return execResultWithResponse(client, postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, String data, String contentType) {
        return execResultWithResponse(client, postRequest(url, headers, data, contentType));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, byte[] data) {
        return execResultWithResponse(client, postRequest(url, null, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, byte[] data) {
        return execResultWithResponse(client, postRequest(url, headers, data, HTTP_CONTENT_TYPE_JSON));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, byte[] data, String contentType) {
        return execResultWithResponse(client, postRequest(url, null, data, contentType));
    }

    public static Response postWithReturnResponse(OkHttpClient client, String url, Map<String, String> headers, byte[] data, String contentType) {
        return execResultWithResponse(client, postRequest(url, headers, data, contentType));
    }

    /**
     * 通用接口
     *
     * @param client
     * @param url
     * @param httpMethod  GET, HEAD, POST, DELETE, PUT, PATCH
     * @param headers
     * @param data
     * @param contentType
     * @return
     */
    public static Response method(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, byte[] data, String contentType) {
        return execResultWithResponse(client, XRequest(url, httpMethod, headers, data, contentType));
    }

    /**
     * 通用接口
     *
     * @param client
     * @param url
     * @param httpMethod  GET, HEAD, POST, DELETE, PUT, PATCH
     * @param headers
     * @param body
     * @param contentType
     * @return
     */
    public static Response methodByBody(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, RequestBody body, String contentType) {
        return execResultWithResponse(client, XRequest(url, httpMethod, headers, body, contentType));
    }

    /**
     * 收口方法
     */

    private static Response execResultWithResponse(OkHttpClient client, Request request) {
        int size = GLOBAL_HOOKS.size();
        Response response = null;
        try {
            // before hook
            for (int idx = 0; idx < size; idx++) {
                response = GLOBAL_HOOKS.get(idx).beforeRequest(request);

                // if not null will return
                if (Objects.nonNull(response)) {
                    return response;
                }
            }

            response = getHeaderHttpHookInvoker().invoke(request, () -> client.newCall(request).execute());

            // after hook
            for (int idx = 0; idx < size; idx++) {
                GLOBAL_HOOKS.get(idx).afterRequest(request, response);
            }

            return response;
        } catch (Throwable e) {
            logger.error("cusc uri: {} ex: {} ", request.url().uri().toString(), e.getMessage(), e);
            throw new RuntimeException(e);
        } finally {
            // completion hook
            for (int idx = size - 1; idx >= 0; idx--) {
                GLOBAL_HOOKS.get(idx).completion(request);
            }
        }
    }

    private HttpSync() {
    }

}
