package com.cusc.nirvana.common.http.client;

import okhttp3.Request;
import okhttp3.Response;

/**
 * @author jeff.chen
 * @file HttpHook
 * @E-mail chenjf159@chinaunicom.cn
 */
public interface HttpHook {

    /**
     * before request execute
     *
     * @param request
     * @return Response if not null will return
     */
    Response beforeRequest(Request request);

    /**
     * after request execute
     *
     * @param request
     * @param response
     */
    void afterRequest(Request request, Response response);

    /**
     * after request execute Completed
     *
     * @param request
     */
    void completion(Request request);

}
