package com.cusc.nirvana.common.http.client;

import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;

/**
 * demo
 * <p>
 * ConnectionPool pool = new ConnectionPool(5, 5, TimeUnit.MINUTES);
 * OkHttpClient client0 = new OkHttpClient().newBuilder()
 * .connectionPool(pool)
 * .connectTimeout(5, TimeUnit.SECONDS)
 * .writeTimeout(5, TimeUnit.SECONDS)
 * .readTimeout(5, TimeUnit.SECONDS).build();
 *
 * @author jeff.chen
 * @file HttpAsync
 * @E-mail chenjf159@chinaunicom.cn
 */
public class HttpAsync extends HttpBase {

    final static Logger logger = LoggerFactory.getLogger(HttpAsync.class);

    static final Callback DEFAULT_CALLBACK = new Callback() {

        @Override
        public void onFailure(Call call, IOException e) {
            logger.error("cusc-tools HttpAsync failure default log url:{} msg:{}", call.request().url().toString(), e.getMessage(), e);
        }

        @Override
        public void onResponse(Call call, Response response) {
            if (logger.isDebugEnabled()) {
                logger.info("cusc HttpAsync success default log url:{} msg:{}", call.request().url().toString());
            }
        }

    };

    public static void get(String url, Callback cb) {
        exec(url, getRequest(url, null), cb);
    }

    public static void get(String url, Map<String, String> headers, Callback cb) {
        exec(url, getRequest(url, headers), cb);
    }

    public static void postByJson(String url, String data, Callback cb) {
        post(url, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void postByJson(String url, Map<String, String> headers, String data, Callback cb) {
        post(url, headers, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void post(String url, String data, String contentType, Callback cb) {
        exec(url, postRequest(url, null, data, contentType), cb);
    }

    public static void post(String url, Map<String, String> headers, String data, String contentType, Callback cb) {
        exec(url, postRequest(url, headers, data, contentType), cb);
    }

    public static void postByJson(String url, byte[] data, Callback cb) {
        post(url, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void postByJson(String url, Map<String, String> headers, byte[] data, Callback cb) {
        post(url, headers, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void post(String url, byte[] data, String contentType, Callback cb) {
        exec(url, postRequest(url, null, data, contentType), cb);
    }

    public static void post(String url, Map<String, String> headers, byte[] data, String contentType, Callback cb) {
        exec(url, postRequest(url, headers, data, contentType), cb);
    }

    private static void exec(String url, Request request, Callback cb) {
        exec(client(url), request, cb);
    }

    /**
     * 自定义  OkHttpClient
     */

    public static void get(OkHttpClient client, String url, Callback cb) {
        exec(client, getRequest(url, null), cb);
    }

    public static void get(OkHttpClient client, String url, Map<String, String> headers, Callback cb) {
        exec(client, getRequest(url, headers), cb);
    }

    public static void postByJson(OkHttpClient client, String url, String data, Callback cb) {
        post(client, url, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void postByJson(OkHttpClient client, String url, Map<String, String> headers, String data, Callback cb) {
        post(client, url, headers, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void post(OkHttpClient client, String url, String data, String contentType, Callback cb) {
        exec(client, postRequest(url, null, data, contentType), cb);
    }

    public static void post(OkHttpClient client, String url, Map<String, String> headers, String data, String contentType, Callback cb) {
        exec(client, postRequest(url, headers, data, contentType), cb);
    }

    public static void postByJson(OkHttpClient client, String url, byte[] data, Callback cb) {
        post(client, url, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void postByJson(OkHttpClient client, String url, Map<String, String> headers, byte[] data, Callback cb) {
        post(client, url, headers, data, HTTP_CONTENT_TYPE_JSON, cb);
    }

    public static void post(OkHttpClient client, String url, byte[] data, String contentType, Callback cb) {
        exec(client, postRequest(url, null, data, contentType), cb);
    }

    public static void post(OkHttpClient client, String url, Map<String, String> headers, byte[] data, String contentType, Callback cb) {
        exec(client, postRequest(url, headers, data, contentType), cb);
    }

    /**
     * 通用接口
     *
     * @param client
     * @param url
     * @param httpMethod  GET, HEAD, POST, DELETE, PUT, PATCH
     * @param headers
     * @param data
     * @param contentType
     * @param cb
     */
    public static void method(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, byte[] data, String contentType, Callback cb) {
        exec(client, XRequest(url, httpMethod, headers, data, contentType), cb);
    }

    public static void methodByBody(OkHttpClient client, String url, HttpMethod httpMethod, Map<String, String> headers, RequestBody body, String contentType, Callback cb) {
        exec(client, XRequest(url, httpMethod, headers, body, contentType), cb);
    }

    /**
     * 收口方法
     */

    private static void exec(OkHttpClient client, Request request, Callback cb) {
        Call call = client.newCall(request);

        call.enqueue(null == cb ? DEFAULT_CALLBACK : cb);
    }

    private HttpAsync() {
    }

}
