package com.cusc.nirvana.common.evn;

import com.cusc.nirvana.common.ConfigKeys;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author jeff.chen
 * @file EnvHelper
 * @E-mail chenjf159@chinaunicom.cn
 */
public class EnvHelper {

    Logger logger = LoggerFactory.getLogger(EnvHelper.class);

    /**
     * default: RtEnv.reject
     */
    final RtEnv currentEnv;

    public boolean match(RtEnv maxEnv) {
        if (RtEnv.reject.equals(currentEnv) || RtEnv.ignore.equals(maxEnv)) {
            return false;
        } else if (RtEnv.allow.equals(currentEnv)) {
            return true;
        } else {
            return maxEnv.getVal() >= currentEnv.getVal();
        }
    }

    public RtEnv getCurrentEnv() {
        return currentEnv;
    }

    private EnvHelper() {
        // env
        String envKey = ConfigKeys.NIRVANA_RT_ENV_KEY;
        String env = System.getProperty(envKey, ConfigKeys.NA);
        if (ConfigKeys.NA.equals(env)) {
            // spring.profiles.active
            envKey = ConfigKeys.ACTIVE_PROFILE;
            env = System.getProperty(envKey, ConfigKeys.NA);
        }
        currentEnv = RtEnv.getEnv(env);

        logger.info("CUSC 当前环境: key={} value={}", envKey, currentEnv.name);
    }

    public static EnvHelper getInstance() {
        return SingletonInternal.instance;
    }

    static class SingletonInternal {
        static EnvHelper instance = new EnvHelper();
    }

    public enum RtEnv {

        /**
         * ignore
         */
        ignore("ignore", 000),
        /**
         * ignore
         */
        reject("reject", 000),
        /**
         * local
         */
        local("local", 111),
        /**
         * dev
         */
        dev("dev", 222),
        /**
         * test
         */
        test("test", 333),
        /**
         * exe
         */
        exe("exe", 444),
        /**
         * pst
         */
        pst("pst", 555),
        /**
         * pre
         */
        cupre("cu-pre", 666),
        /**
         * pre
         */
        pre("pre", 777),
        /**
         * prod
         */
        prod("prod", 888),
        /**
         * pre
         */
        cuprod("cu-prod", 889),
        /**
         * allow
         */
        allow("allow", 999);

        String name;

        int val;

        RtEnv(String name, int val) {
            this.name = name;
            this.val = val;
        }

        public String getName() {
            return this.name;
        }

        public int getVal() {
            return this.val;
        }

        public static RtEnv getEnv(String name) {
            if (StringUtils.isBlank(name)) {
                return reject;
            }

            if (allow.getName().equalsIgnoreCase(name)) {
                return allow;
            }

            if (cuprod.getName().equalsIgnoreCase(name)) {
                return cuprod;
            }

            if (prod.getName().equalsIgnoreCase(name)) {
                return prod;
            }

            if (cupre.getName().equalsIgnoreCase(name)) {
                return cupre;
            }

            if (pre.getName().equalsIgnoreCase(name)) {
                return pre;
            }

            if (pst.getName().equalsIgnoreCase(name)) {
                return pst;
            }

            if (exe.getName().equalsIgnoreCase(name)) {
                return exe;
            }

            if (test.getName().equalsIgnoreCase(name)) {
                return test;
            }

            if (dev.getName().equalsIgnoreCase(name)) {
                return dev;
            }

            if (local.getName().equalsIgnoreCase(name)) {
                return local;
            }

            return reject;
        }
    }

}
