package com.cusc.nirvana.common.encrypt.xor;

/**
 * @author jeff.chen
 * @file XOR
 * @E-mail chenjf159@chinaunicom.cn
 */
public class XOR {

    /**
     * 异或
     *
     * @param data          待校验数据
     * @param expectedValue 期望值
     * @return
     */
    public static boolean verify(byte[] data, int expectedValue) {
        int result = 0;
        for (int i = 0; i < data.length; i++) {
            result = result ^ (data[i] & 0xFF);
        }

        return result == expectedValue;
    }

    /**
     * 计算
     *
     * @param data 待计算数据
     * @return
     */
    public static int calc(byte[] data) {
        int result = 0;
        for (int i = 0; i < data.length; i++) {
            result = result ^ (data[i] & 0xFF);
        }

        return result;
    }

}
