package com.cusc.nirvana.common.encrypt.sign;

import com.cusc.nirvana.common.encrypt.Util;
import org.apache.commons.lang3.StringUtils;

import java.security.MessageDigest;

/**
 * 签名|摘要
 *
 * @author jeff.chen
 * @file SHA
 * @E-mail chenjf159@chinaunicom.cn
 */
public class SHA {

    /**
     * 签名
     *
     * @param content   待签名内容
     * @param algorithm 签名算法
     * @return
     * @throws Exception
     */
    public static final String sign(String content, Type algorithm) throws Exception {
        if (StringUtils.isBlank(content)) {
            return null;
        }

        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm.algorithm);
            digest.update(content.getBytes("UTF-8"));
            return Util.parseByte2HexStr(digest.digest());
        } catch (Exception e) {
            throw new Exception("SHA sign:" + algorithm.algorithm + " " + e.getMessage());
        }
    }

    public enum Type {
        /**
         * SHA-1
         */
        SHA1("SHA-1"),
        /**
         * SHA-224
         */
        SHA224("SHA-224"),
        /**
         * SHA-256
         */
        SHA256("SHA-256"),
        /**
         * SHA-384
         */
        SHA384("SHA-384"),
        /**
         * SHA-512
         */
        SHA512("SHA-512"),
        /**
         * MD5
         */
        MD5("MD5");

        String algorithm;

        Type(String algorithm) {
            this.algorithm = algorithm;
        }

    }

}
