package com.cusc.nirvana.common.encrypt.aes;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.SecureRandom;

/**
 * https://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html
 * http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html
 *
 * @author jeff.chen
 * @file AES
 * @E-mail chenjf159@chinaunicom.cn
 */
public abstract class AbstractAES {

    protected final static int IV_LEN = 16;
    protected final static String DEFAULT_IV = "NLRUZyE8lX2K3ABC";

    protected byte[] key;
    protected String iv = DEFAULT_IV;

    protected IvParameterSpec ivSpec;
    protected SecretKeySpec keySpec;
    protected Cipher cipher;

    protected final void setSecretKey(byte[] passwd, boolean useKeyGenerator, SecretLevel level) throws Exception {
        checkKeyLen(passwd);

        this.key = passwd;
        keySpec = useKeyGenerator ? newSecretKeySpec(key, level) : newSecretKeySpec(key);
    }

    protected final static SecretKeySpec newSecretKeySpec(byte[] passwd) throws Exception {
        // 避免平台差异化
        return new SecretKeySpec(passwd, "AES");
    }

    protected final static SecretKeySpec newSecretKeySpec(byte[] passwd, SecretLevel level) throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(level.level, new SecureRandom(passwd));
        javax.crypto.SecretKey secretKey = keyGen.generateKey();
        byte[] bytes = secretKey.getEncoded();

        return new SecretKeySpec(bytes, "AES");
    }

    protected final static IvParameterSpec newIvParameterSpec(String iv) throws Exception {
        return new IvParameterSpec(iv.getBytes("UTF-8"));
    }

    protected final static String padString(String source) {
        char paddingChar = 0;
        int size = 16;
        int x = source.length() % size;
        int padLength = size - x;

        for (int i = 0; i < padLength; i++) {
            source += paddingChar;
        }

        return source;
    }

    protected final static String removeTrailingZeroes(byte[] decrypted) throws Exception {
        if (decrypted.length > 0) {
            int trim = 0;
            for (int i = decrypted.length - 1; i >= 0; i--) {
                if (decrypted[i] == 0) {
                    trim++;
                }
            }

            if (trim > 0) {
                byte[] newArray = new byte[decrypted.length - trim];
                System.arraycopy(decrypted, 0, newArray, 0, decrypted.length - trim);
                decrypted = newArray;
            }
        }

        return new String(decrypted, "UTF-8");
    }

    public final static String encodeBase64(byte[] buffer) {
        return Base64.encodeBase64String(buffer);
    }

    public final static byte[] decodeBase64(String input) {
        return Base64.decodeBase64(input);
    }

    /**
     * 加密
     *
     * @param text
     * @return
     * @throws Exception
     */
    public abstract String encrypt(String text) throws Exception;

    /**
     * 解密
     *
     * @param code
     * @return
     * @throws Exception
     */
    public abstract String decrypt(String code) throws Exception;

    protected final static void checkViLen(String iv0) throws Exception {
        if (iv0.length() != IV_LEN) {
            throw new Exception("IV length must " + IV_LEN);
        }
    }

    protected final static void checkKeyLen(byte[] passwd) throws Exception {
        if (passwd.length != 16 && passwd.length != 24 && passwd.length != 32) {
            throw new Exception("Key length must in {16, 24, 32}");
        }
    }

    /**
     * 预定义加密长度
     */
    public enum SecretLevel {

        /**
         * 128
         */
        AES128(128),
        /**
         * 192
         */
        AES192(192),
        /**
         * 256
         */
        AES256(256);

        int level = 128;

        SecretLevel(int level) {
            this.level = level;
        }
    }

}
