package com.cusc.nirvana.common.encrypt.aes;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import javax.crypto.Cipher;
import java.security.Security;

/**
 * (对称)
 * AES，CBC模式，PKCS7Padding补码
 *
 * @author jeff.chen
 * @file AESCBCPKCS7
 * @E-mail chenjf159@chinaunicom.cn
 */
public class AESCBCPKCS7 extends AbstractAES {

    static {
        if (null == Security.getProvider(BouncyCastleProvider.PROVIDER_NAME)) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    /**
     * 非线程安全
     *
     * @param key 16/128, 24/192, 32/256
     * @throws Exception
     */
    public AESCBCPKCS7(String key) throws Exception {
        this(DEFAULT_IV, key, false, SecretLevel.AES128);
    }

    /**
     * 非线程安全
     *
     * @param iv
     * @param passwd          16/128, 24/192, 32/256
     * @param useKeyGenerator default: false  不使用
     * @param level           仅 (@param useKeyGenerator == true) 场景 @param level 有效
     * @throws Exception
     */
    public AESCBCPKCS7(String iv, String passwd, boolean useKeyGenerator, SecretLevel level) throws Exception {
        this(iv, passwd.getBytes("UTF-8"), useKeyGenerator, level);
    }

    /**
     * @param iv
     * @param passwd          16/128, 24/192, 32/256
     * @param useKeyGenerator
     * @param level
     * @throws Exception
     */
    public AESCBCPKCS7(String iv, byte[] passwd, boolean useKeyGenerator, SecretLevel level) throws Exception {
        checkViLen(iv);
        this.iv = iv;

        this.setSecretKey(passwd, useKeyGenerator, level);

        ivSpec = newIvParameterSpec(iv);
        cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
    }

    /**
     * 非线程安全
     *
     * @param text
     * @return
     * @throws Exception
     */
    @Override
    public String encrypt(String text) throws Exception {
        try {
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, ivSpec);
            byte[] encrypted = cipher.doFinal(padString(text).getBytes());

            return encodeBase64(encrypted);
        } catch (Exception e) {
            throw new Exception("[encrypt] " + e.getMessage());
        }
    }

    /**
     * 非线程安全
     *
     * @param code
     * @return
     * @throws Exception
     */
    @Override
    public String decrypt(String code) throws Exception {
        if (code == null || code.length() == 0) {
            return null;
        }

        try {
            cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);

            byte[] decrypted = cipher.doFinal(decodeBase64(code));

            return removeTrailingZeroes(decrypted);
        } catch (Exception e) {
            throw new Exception("[decrypt] " + e.getMessage());
        }
    }

    /**
     * 线程安全
     *
     * @param text
     * @param key  16/128, 24/192, 32/256
     * @return
     * @throws Exception
     */
    public final static String encrypt(String text, String key) throws Exception {
        return encrypt(text, key, DEFAULT_IV);
    }

    public final static String encrypt(String text, byte[] key) throws Exception {
        return encrypt(text, key, DEFAULT_IV);
    }

    /**
     * 线程安全
     *
     * @param text
     * @param key  16/128, 24/192, 32/256
     * @param iv
     * @return
     * @throws Exception
     */
    public final static String encrypt(String text, String key, String iv) throws Exception {
        return encrypt(text, key.getBytes("UTF-8"), iv);
    }

    public final static String encrypt(String text, byte[] key, String iv) throws Exception {
        checkViLen(iv);

        Cipher cipher0 = Cipher.getInstance("AES/CBC/PKCS7Padding");

        try {
            cipher0.init(Cipher.ENCRYPT_MODE, newSecretKeySpec(key), newIvParameterSpec(iv));
            byte[] encrypted = cipher0.doFinal(padString(text).getBytes());

            return encodeBase64(encrypted);
        } catch (Exception e) {
            throw new Exception("[encrypt] " + e.getMessage());
        }
    }

    /**
     * 线程安全
     *
     * @param code
     * @param key  16/128, 24/192, 32/256
     * @return
     * @throws Exception
     */
    public final static String decrypt(String code, String key) throws Exception {
        return decrypt(code, key, DEFAULT_IV);
    }

    public final static String decrypt(String code, byte[] key) throws Exception {
        return decrypt(code, key, DEFAULT_IV);
    }

    /**
     * 线程安全
     *
     * @param code
     * @param key  16/128, 24/192, 32/256
     * @param iv
     * @return
     * @throws Exception
     */
    public final static String decrypt(String code, String key, String iv) throws Exception {
        return decrypt(code, key.getBytes("UTF-8"), iv);
    }

    public final static String decrypt(String code, byte[] key, String iv) throws Exception {
        if (code == null || code.length() == 0) {
            return null;
        }

        checkViLen(iv);

        Cipher cipher0 = Cipher.getInstance("AES/CBC/PKCS7Padding");

        try {
            cipher0.init(Cipher.DECRYPT_MODE, newSecretKeySpec(key), newIvParameterSpec(iv));

            byte[] decrypted = cipher0.doFinal(decodeBase64(code));

            return removeTrailingZeroes(decrypted);
        } catch (Exception e) {
            throw new Exception("[decrypt] " + e.getMessage());
        }
    }

}
