package com.cusc.nirvana.common.encrypt;

import org.apache.commons.codec.binary.Base64;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * @author jeff.chen
 * @file Util
 * @E-mail chenjf159@chinaunicom.cn
 */
public class Util {

    /**
     * 将二进制转换成16进制
     */
    public static String parseByte2HexStr(byte buf[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }

        return sb.toString();
    }

    /**
     * 将16进制转换为二进制
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }

        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2),
                    16);
            result[i] = (byte) (high * 16 + low);
        }

        return result;
    }

    /**
     * 从密钥对获取 私钥
     *
     * @param keyPair
     * @return
     */
    public static String privateKey(KeyPair keyPair) {
        byte[] privateKey = keyPair.getPrivate().getEncoded();
        return Base64.encodeBase64String(privateKey);
    }

    /**
     * 从密钥对获取 公钥
     *
     * @param keyPair
     * @return
     */
    public static String publicKey(KeyPair keyPair) {
        byte[] publicKey = keyPair.getPublic().getEncoded();
        return Base64.encodeBase64String(publicKey);
    }

    /**
     * print KeyPair to console for test
     *
     * @param keyPair
     */
    public static void print(KeyPair keyPair) {
        // 分别得到公钥和私钥
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();

        // 使用 Base64编码
        String publicKeyStr = Base64.encodeBase64String(publicKey.getEncoded());
        String privateKeyStr = Base64.encodeBase64String(privateKey.getEncoded());

        System.out.println(publicKeyStr);
        System.err.println(privateKeyStr);
    }

}
