package com.cusc.nirvana.common;

/**
 * @author jeff.chen
 * @file ExceptionUtils
 * @E-mail chenjf159@chinaunicom.cn
 */
public class ExceptionUtils {

    private ExceptionUtils() {
    }

    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String getFullStackTrace(Throwable t) {
        if (null == t) {
            return "null";
        }

        StackTraceElement[] items = t.getStackTrace();

        StringBuilder stringBuilder = new StringBuilder();

        stringBuilder.append(" Exception: ");
        stringBuilder.append(t.getMessage());
        stringBuilder.append(LINE_SEPARATOR);

        for (int i = 0; i < items.length; i++) {
            stringBuilder.append(" at: ");
            stringBuilder.append(items[i].getClassName());
            stringBuilder.append(".");
            stringBuilder.append(items[i].getMethodName());
            stringBuilder.append("(");
            stringBuilder.append(items[i].getFileName());
            stringBuilder.append(":");
            stringBuilder.append(items[i].getLineNumber());
            stringBuilder.append(")");
            stringBuilder.append(LINE_SEPARATOR);
        }

        return stringBuilder.toString();
    }

}
