/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.uid;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;

public class UtilTools {
    private static String IP_ADDRESS = "";
    private static int PROCESS_ID = 0;
    private static String STR_PROCESS_ID = "N/A";
    private static char[] charSet32 = "0123456789ABCDEFGHJKLMNPQRSTUVWX".toCharArray();
    static final char PRE_FILL = 'O';
    static final int BIT_5 = 5;
    static final int VAL_31 = 31;

    private UtilTools() {
    }

    public static final int getProcessID() {
        if (PROCESS_ID > 0) {
            return PROCESS_ID;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        PROCESS_ID = Integer.parseInt(runtimeMXBean.getName().split("@")[0]);
        STR_PROCESS_ID = String.valueOf(PROCESS_ID);
        return PROCESS_ID;
    }

    public static final String getStrProcessID() {
        if (PROCESS_ID > 0) {
            return STR_PROCESS_ID;
        }
        UtilTools.getProcessID();
        return STR_PROCESS_ID;
    }

    public static String base10ToBase32String(long idx) {
        StringBuilder stringBuilder = new StringBuilder();
        long val = idx;
        while (val != 0L) {
            stringBuilder.append(charSet32[(int)(val & 0x1FL)]);
            val >>= 5;
        }
        return stringBuilder.toString();
    }

    public static long base32String2Base10Long(String base32String) {
        String str = UtilTools.trim(base32String);
        long base10 = 0L;
        int length = str.length();
        int i = length - 1;
        while (i >= 0) {
            base10 <<= 5;
            char ch = str.charAt(i);
            int j = 0;
            while (j < charSet32.length) {
                if (ch == charSet32[j]) {
                    base10 ^= (long)j;
                    break;
                }
                ++j;
            }
            --i;
        }
        return base10;
    }

    public static String getLocalMac() {
        InetAddress local = UtilTools.getInetAddress();
        try {
            return UtilTools.byte2String(NetworkInterface.getByInetAddress(local).getHardwareAddress());
        }
        catch (SocketException e) {
            throw new IllegalStateException("\u83b7\u53d6\u672c\u5730MAC\u5730\u5740\u5931\u8d25", e);
        }
    }

    public static String reverse2Mac(String base32MacString) {
        long mac = UtilTools.base32String2Base10Long(base32MacString);
        StringJoiner stringJoiner = new StringJoiner(":");
        String hexStr = Long.toHexString(mac);
        int idx = 0;
        while (idx < hexStr.length()) {
            String bitHex = hexStr.substring(idx, idx + 2);
            stringJoiner.add(bitHex.toUpperCase());
            idx += 2;
        }
        return stringJoiner.toString();
    }

    public static String getLocalIP() {
        InetAddress local = UtilTools.getInetAddress();
        return UtilTools.byte2String(local.getAddress());
    }

    public static InetAddress getCurrentIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> enumerationInetAddress = networkInterface.getInetAddresses();
                while (enumerationInetAddress.hasMoreElements()) {
                    InetAddress inetAddress = enumerationInetAddress.nextElement();
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException e) {
            throw new IllegalStateException("\u83b7\u53d6\u672c\u5730IP\u5730\u5740\u5931\u8d25 getCurrentIp()", e);
        }
        throw new IllegalStateException("\u83b7\u53d6\u672c\u5730IP\u5730\u5740\u5931\u8d25 \u5339\u914d\u52300\u4e2a\u53ef\u7528IP");
    }

    public static String getHostAddress() {
        if (StringUtils.isNotBlank((CharSequence)IP_ADDRESS)) {
            return IP_ADDRESS;
        }
        InetAddress local = UtilTools.getInetAddress();
        IP_ADDRESS = local.getHostAddress();
        return IP_ADDRESS;
    }

    private static InetAddress getInetAddress() {
        InetAddress local;
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            local = UtilTools.getCurrentIp();
        }
        return local;
    }

    public static String reverse2IP(String base32IPString) {
        long address = UtilTools.base32String2Base10Long(base32IPString);
        StringJoiner stringJoiner = new StringJoiner(".");
        String hexStr = Long.toHexString(address);
        if (1 == hexStr.length() % 2) {
            hexStr = "0" + hexStr;
        }
        int idx = 0;
        while (idx < hexStr.length()) {
            String bitHex = hexStr.substring(idx, idx + 2);
            stringJoiner.add(String.valueOf(Integer.parseInt(bitHex, 16)));
            idx += 2;
        }
        return stringJoiner.toString();
    }

    private static String byte2String(byte[] bytes) {
        return UtilTools.byte2String(bytes, 10);
    }

    private static String byte2String(byte[] bytes, int fixedLen) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            int temp = bytes[i] & 0xFF;
            if (temp > 15) {
                stringBuilder.append(Integer.toHexString(temp));
            } else {
                stringBuilder.append(0);
                stringBuilder.append(Integer.toHexString(temp));
            }
            ++i;
        }
        long val1 = Long.parseLong(stringBuilder.toString(), 16);
        String base32Str = UtilTools.base10ToBase32String(val1);
        return UtilTools.appendPrefixWithFixedLength(base32Str, fixedLen);
    }

    public static String appendPrefixWithFixedLength(String base32Str, int fixedLen) {
        return UtilTools.appendPrefixWithFixedLength('O', base32Str, fixedLen);
    }

    public static String appendPrefixWithFixedLength(char fill, String base32Str, int fixedLen) {
        int len = base32Str.length();
        if (len < fixedLen) {
            StringBuilder prefix = new StringBuilder();
            int i = 0;
            while (i < fixedLen - len) {
                prefix.append(fill);
                ++i;
            }
            return prefix.append(base32Str).toString();
        }
        if (len > fixedLen) {
            throw new IllegalStateException("\u5b57\u7b26\u4e32\u8d85\u957f");
        }
        return base32Str;
    }

    private static String trim(String base32IPString) {
        int startIndex = 0;
        int i = 0;
        while (i < base32IPString.length()) {
            if ('O' != base32IPString.charAt(i)) break;
            ++startIndex;
            ++i;
        }
        return startIndex == 0 ? base32IPString : base32IPString.substring(startIndex);
    }

    public static String fixedLengthRandomHexString(int length) {
        if (length <= 0) {
            length = 1;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < length) {
            stringBuilder.append(charSet32[random.nextInt(32)]);
            ++i;
        }
        return stringBuilder.toString();
    }
}

