/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.result;

import com.alibaba.fastjson.JSON;
import com.cusc.nirvana.common.result.BaseEnum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Response<T>
implements Serializable {
    static final Object EMPTY = new Object();
    private String msg;
    private Integer code;
    private T data;
    private Boolean success;
    private String exception;
    private Map<String, String> attachment;

    protected Response() {
    }

    private Response(String msg, Integer code, T data, Boolean success) {
        this.msg = msg;
        this.code = code;
        this.data = data;
        this.success = success;
    }

    public Response(String msg, T data, Boolean success) {
        this.msg = msg;
        this.data = data;
        this.success = success;
    }

    public Response(String msg, Boolean success) {
        this.msg = msg;
        this.success = success;
    }

    public Response(String msg, Integer code, T data, Boolean success, String exception) {
        this.msg = msg;
        this.code = code;
        this.data = data;
        this.success = success;
        this.exception = exception;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public static Response createSuccess(String msg) {
        return Response.createSuccess(msg, null);
    }

    public static Response createSuccess(Object data) {
        return Response.createSuccess(BaseEnum.SUCCESS.getMsg(), data);
    }

    public static Response createSuccess(String msg, Object data) {
        return Response.createSuccess(msg, BaseEnum.SUCCESS.getCode(), data);
    }

    public static Response createSuccess(String msg, Object data, String ... args) {
        return Response.createFormatMsg(msg, BaseEnum.SUCCESS.getCode(), data, true, args);
    }

    public static Response createSuccess(String msg, String ... args) {
        return Response.createFormatMsg(msg, BaseEnum.SUCCESS.getCode(), null, true, args);
    }

    public static Response createSuccess(String msg, Integer code, Object data) {
        return new Response<Object>(msg, code, data, true);
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public static Response createSuccess() {
        return new Response<Object>(BaseEnum.SUCCESS.getMsg(), BaseEnum.SUCCESS.getCode(), null, true);
    }

    public static Response createError() {
        return new Response<Object>(BaseEnum.ERROR.getMsg(), BaseEnum.ERROR.getCode(), EMPTY, false);
    }

    public static Response createError(String msg) {
        return Response.createFormatMsg(msg, BaseEnum.ERROR.getCode(), EMPTY, false, new String[0]);
    }

    public static Response createError(String msg, String ... args) {
        return Response.createFormatMsg(msg, BaseEnum.ERROR.getCode(), EMPTY, false, args);
    }

    public static Response createError(String msg, Object data, String ... args) {
        return Response.createFormatMsg(msg, BaseEnum.ERROR.getCode(), data, false, args);
    }

    public static Response createError(String msg, Object data) {
        return new Response<Object>(msg, BaseEnum.ERROR.getCode(), data, false);
    }

    public static Response createError(String msg, Integer code, Object data) {
        return new Response<Object>(msg, code, data, false);
    }

    public static Response createError(String msg, Integer code) {
        return Response.createFormatMsg(msg, code, EMPTY, false, new String[0]);
    }

    public static Response createError(String msg, String exception) {
        return new Response<Object>(msg, BaseEnum.ERROR.getCode(), EMPTY, false, exception);
    }

    private static Response createFormatMsg(String msg, Integer code, Object data, Boolean success, String ... args) {
        return new Response<Object>(String.format(msg, args), code, data, success);
    }

    public Map<String, String> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Map<String, String> attachment) {
        if (attachment == null) {
            return;
        }
        this.attachment = attachment;
    }

    public synchronized void setAttachment(String key, String value) {
        if (this.attachment == null) {
            this.attachment = new HashMap<String, String>(8);
        }
        this.attachment.put(key, value);
    }

    public String toString() {
        return "Response{msg='" + this.msg + '\'' + ", code=" + this.code + ", data=" + JSON.toJSONString(this.data) + ", success=" + this.success + ", exception='" + this.exception + '\'' + ", attachment=" + JSON.toJSONString(this.attachment) + '}';
    }
}

