/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.loader;

import com.cusc.nirvana.common.ExceptionUtils;
import com.cusc.nirvana.common.Initialize;
import com.cusc.nirvana.common.evn.EnvHelper;
import com.cusc.nirvana.common.loader.CollectionUtils;
import com.cusc.nirvana.common.loader.EnhancedServiceNotFoundException;
import com.cusc.nirvana.common.loader.LoadLevel;
import com.cusc.nirvana.common.loader.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedServiceLoader {
    private static final Logger logger = LoggerFactory.getLogger(EnhancedServiceLoader.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static Map<Class, List<Class>> providers = new ConcurrentHashMap<Class, List<Class>>();

    public static <S> S load(Class<S> service, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, null, loader);
    }

    public static <S> S load(Class<S> service) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, null, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, loader);
    }

    public static <S> S load(Class<S> service, String activateName, Object[] args) throws EnhancedServiceNotFoundException {
        Class[] argsType = null;
        if (args != null && args.length > 0) {
            argsType = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argsType[i] = args[i].getClass();
                ++i;
            }
        }
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader(), argsType, args);
    }

    public static <S> S load(Class<S> service, String activateName, Class[] argsType, Object[] args) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader(), argsType, args);
    }

    public static <S> List<S> loadAll(Class<S> service) {
        ArrayList<S> allInstances = new ArrayList<S>();
        List<Class> allClazzs = EnhancedServiceLoader.getAllExtensionClass(service);
        if (CollectionUtils.isEmpty(allClazzs)) {
            return allInstances;
        }
        try {
            for (Class clazz : allClazzs) {
                allInstances.add(EnhancedServiceLoader.initInstance(service, clazz, null, null));
            }
        }
        catch (Throwable t) {
            throw new EnhancedServiceNotFoundException(t);
        }
        logger.info("cusc {} load\u6210\u529f\u3002", service);
        return allInstances;
    }

    public static <S> List<Class> getAllExtensionClass(Class<S> service) {
        return EnhancedServiceLoader.findAllExtensionClass(service, null, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> List<Class> getAllExtensionClass(Class<S> service, ClassLoader loader) {
        return EnhancedServiceLoader.findAllExtensionClass(service, null, loader);
    }

    private static <S> S loadFile(Class<S> service, String activateName, ClassLoader loader) {
        return EnhancedServiceLoader.loadFile(service, activateName, loader, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> S loadFile(Class<S> service, String activateName, ClassLoader loader, Class[] argTypes, Object[] args) {
        try {
            boolean foundFromCache = true;
            List<Class> extensions = providers.get(service);
            if (extensions == null) {
                Class<S> clazz = service;
                synchronized (clazz) {
                    extensions = providers.get(service);
                    if (extensions == null) {
                        extensions = EnhancedServiceLoader.findAllExtensionClass(service, activateName, loader);
                        foundFromCache = false;
                        providers.put(service, extensions);
                    }
                }
            }
            if (StringUtils.isNotBlank(activateName)) {
                ArrayList<Class> activateExtensions = new ArrayList<Class>();
                int i = 0;
                while (i < extensions.size()) {
                    Class clz = extensions.get(i);
                    LoadLevel activate = clz.getAnnotation(LoadLevel.class);
                    if (activate != null && activateName.equalsIgnoreCase(activate.name())) {
                        activateExtensions.add(clz);
                    }
                    ++i;
                }
                extensions = activateExtensions;
            }
            if (extensions.isEmpty()) {
                throw new EnhancedServiceNotFoundException("not found service provider for : " + service.getName() + "[" + activateName + "] and classloader : " + EnhancedServiceLoader.toString(loader));
            }
            Class extension = extensions.get(extensions.size() - 1);
            S result = EnhancedServiceLoader.initInstance(service, extension, argTypes, args);
            if (!foundFromCache && logger.isInfoEnabled()) {
                logger.info("cusc load " + service.getSimpleName() + "[" + activateName + "] extension by class[" + extension.getName() + "]");
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof EnhancedServiceNotFoundException) {
                throw (EnhancedServiceNotFoundException)e;
            }
            throw new EnhancedServiceNotFoundException("not found service provider for : " + service.getName() + " caused by " + ExceptionUtils.getFullStackTrace(e));
        }
    }

    private static <S> List<Class> findAllExtensionClass(Class<S> service, String activateName, ClassLoader loader) {
        ArrayList<Class> extensions = new ArrayList<Class>();
        try {
            EnhancedServiceLoader.loadFile(service, SERVICES_DIRECTORY, loader, extensions);
        }
        catch (IOException e) {
            throw new EnhancedServiceNotFoundException(e);
        }
        if (extensions.isEmpty()) {
            return extensions;
        }
        Collections.sort(extensions, new Comparator<Class>(){

            @Override
            public int compare(Class c1, Class c2) {
                Integer o1 = 0;
                Integer o2 = 0;
                LoadLevel a1 = c1.getAnnotation(LoadLevel.class);
                LoadLevel a2 = c2.getAnnotation(LoadLevel.class);
                if (a1 != null) {
                    if (a2 == null && EnvHelper.getInstance().match(a1.activateEnv())) {
                        return 1;
                    }
                    o1 = a1.order();
                }
                if (a2 != null) {
                    if (a1 == null && EnvHelper.getInstance().match(a2.activateEnv())) {
                        return -1;
                    }
                    o2 = a2.order();
                }
                if (a1 == null && a2 == null) {
                    return o1.compareTo(o2);
                }
                if (a1.activateEnv().equals((Object)a2.activateEnv())) {
                    return o1.compareTo(o2);
                }
                if (!EnvHelper.getInstance().match(a1.activateEnv()) && !EnvHelper.getInstance().match(a2.activateEnv())) {
                    return o1.compareTo(o2);
                }
                if (EnvHelper.getInstance().match(a1.activateEnv()) && EnvHelper.getInstance().match(a2.activateEnv())) {
                    return Integer.compare(a1.activateEnv().getVal(), a2.activateEnv().getVal());
                }
                if (EnvHelper.getInstance().match(a1.activateEnv()) && !EnvHelper.getInstance().match(a2.activateEnv())) {
                    return 1;
                }
                if (!EnvHelper.getInstance().match(a1.activateEnv()) && EnvHelper.getInstance().match(a2.activateEnv())) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
        return extensions;
    }

    private static void loadFile(Class<?> service, String dir, ClassLoader classLoader, List<Class> extensions) throws IOException {
        String fileName = String.valueOf(dir) + service.getName();
        Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(url.openStream(), DEFAULT_CHARSET));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        extensions.add(Class.forName(line, true, classLoader));
                    }
                }
                catch (ClassNotFoundException line) {
                    try {
                        if (reader == null) continue;
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                catch (Throwable e) {
                    try {
                        logger.warn("cusc Exception:{}", (Object)e.getMessage());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    if (reader == null) continue;
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected static <S> S initInstance(Class<S> service, Class implClazz, Class[] argTypes, Object[] args) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        S s = null;
        if (argTypes != null && args != null) {
            Constructor constructor = implClazz.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            s = service.cast(constructor.newInstance(args));
        } else {
            s = service.cast(implClazz.newInstance());
        }
        if (s instanceof Initialize) {
            ((Initialize)s).init();
        }
        return s;
    }

    private static ClassLoader findClassLoader() {
        return EnhancedServiceLoader.class.getClassLoader();
    }

    private static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }
}

