/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.http.client;

import com.cusc.nirvana.common.Callback;
import com.cusc.nirvana.common.http.client.AbstractHttpInvokerHandler;
import com.cusc.nirvana.common.http.client.HttpHelper;
import com.cusc.nirvana.common.http.client.HttpHook;
import com.cusc.nirvana.common.http.client.HttpMethod;
import com.cusc.nirvana.common.loader.EnhancedServiceLoader;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBase {
    private static Logger logger = LoggerFactory.getLogger(HttpBase.class);
    public static final String CONTENT_TYPE = "content-type";
    public static final String HTTP_CONTENT_TYPE_JSON = "application/json;charset=UTF-8";
    public static final String CONNECTION = "Connection";
    public static final String KEEP_ALIVE = "Keep-Alive";
    public static final String CLOSE = "close";
    public static final String HTTPS = "https";
    private static final OkHttpClient[] OK_HTTP_CLIENTS = new OkHttpClient[3];
    private static final int HTTP_INDEX = 0;
    private static final int HTTPS_SSL_INDEX = 1;
    private static final int HTTPS_TSL_INDEX = 2;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_IDLE_CONNECTIONS = 5;
    private static final int DEFAULT_KEEP_ALIVE_DURATION = 5;
    private static final Object LOCK = new Object();
    protected static final byte[] DEFAULT_EMPTY = new byte[0];
    protected static final List<HttpHook> GLOBAL_HOOKS = new ArrayList<HttpHook>();
    private static final AtomicBoolean LOADED_INVOKERS = new AtomicBoolean(false);
    private static final AbstractHttpInvokerHandler HEADER_HANDLER = new AbstractHttpInvokerHandler(){

        @Override
        public Response invoke(Request request, Callback<Response> callback) throws Throwable {
            return this.getNext().invoke(request, callback);
        }
    };
    private static final AbstractHttpInvokerHandler TAIL_HANDLER = new AbstractHttpInvokerHandler(){

        @Override
        public Response invoke(Request request, Callback<Response> callback) throws Throwable {
            return callback.call();
        }
    };

    protected static OkHttpClient client(String url) {
        if (HttpBase.isBlank(url)) {
            throw new IllegalArgumentException("cusc HttpBase url is blank");
        }
        if (url.toLowerCase().contains(HTTPS)) {
            return HttpBase.sslClient();
        }
        return HttpBase.client();
    }

    protected static Request getRequest(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().url(url);
        HttpHelper.wrapTracing(builder, headers);
        return builder.get().build();
    }

    protected static Request postRequest(String url, Map<String, String> headers, String data, String contentType) {
        MediaType mediaType = MediaType.parse((String)contentType);
        Request.Builder builder = new Request.Builder().url(url).addHeader(CONTENT_TYPE, contentType);
        HttpHelper.wrapTracing(builder, headers);
        RequestBody body = HttpBase.isBlank(data) ? RequestBody.create((MediaType)mediaType, (byte[])DEFAULT_EMPTY) : RequestBody.create((MediaType)mediaType, (String)data);
        return builder.post(body).build();
    }

    protected static Request postRequest(String url, Map<String, String> headers, byte[] data, String contentType) {
        MediaType mediaType = MediaType.parse((String)contentType);
        Request.Builder builder = new Request.Builder().url(url).addHeader(CONTENT_TYPE, contentType);
        HttpHelper.wrapTracing(builder, headers);
        RequestBody body = RequestBody.create((MediaType)mediaType, (byte[])(data == null ? DEFAULT_EMPTY : data));
        return builder.post(body).build();
    }

    protected static Request XRequest(String url, HttpMethod httpMethod, Map<String, String> headers, byte[] data, String contentType) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(CONTENT_TYPE, contentType);
        HttpHelper.wrapTracing(builder, headers);
        switch (httpMethod) {
            case GET: 
            case HEAD: {
                return builder.method(httpMethod.method, null).build();
            }
            case POST: 
            case DELETE: 
            case PUT: 
            case PATCH: {
                MediaType mediaType = MediaType.parse((String)contentType);
                RequestBody body = data == null ? Util.EMPTY_REQUEST : RequestBody.create((MediaType)mediaType, (byte[])data);
                return builder.method(httpMethod.method, body).build();
            }
        }
        throw new IllegalStateException("cusc HttpBase X-Request");
    }

    protected static Request XRequest(String url, HttpMethod httpMethod, Map<String, String> headers, RequestBody body, String contentType) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(CONTENT_TYPE, contentType);
        HttpHelper.wrapTracing(builder, headers);
        return builder.method(httpMethod.method, body).build();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OkHttpClient client() {
        OkHttpClient client = OK_HTTP_CLIENTS[0];
        if (client == null) {
            Object object = LOCK;
            synchronized (object) {
                client = OK_HTTP_CLIENTS[0];
                if (client == null) {
                    ConnectionPool pool = new ConnectionPool(5, 5L, TimeUnit.MINUTES);
                    HttpBase.OK_HTTP_CLIENTS[0] = client = new OkHttpClient().newBuilder().readTimeout(10000L, TimeUnit.MILLISECONDS).connectTimeout(10000L, TimeUnit.MILLISECONDS).writeTimeout(10000L, TimeUnit.MILLISECONDS).connectionPool(pool).build();
                }
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OkHttpClient sslClient() {
        OkHttpClient sslClient = OK_HTTP_CLIENTS[1];
        if (sslClient == null) {
            Object object = LOCK;
            synchronized (object) {
                sslClient = OK_HTTP_CLIENTS[1];
                if (sslClient == null) {
                    ConnectionPool pool = new ConnectionPool(5, 5L, TimeUnit.MINUTES);
                    OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(10000L, TimeUnit.MILLISECONDS).connectTimeout(10000L, TimeUnit.MILLISECONDS).writeTimeout(10000L, TimeUnit.MILLISECONDS).connectionPool(pool);
                    try {
                        SSLContext sc = SSLContext.getInstance("SSL");
                        X509TrustManager defaultX509TrustManager = new X509TrustManager(){

                            @Override
                            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                            }

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return new X509Certificate[0];
                            }
                        };
                        sc.init(null, new TrustManager[]{defaultX509TrustManager}, new SecureRandom());
                        HttpBase.OK_HTTP_CLIENTS[1] = sslClient = builder.sslSocketFactory(sc.getSocketFactory(), defaultX509TrustManager).build();
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    catch (KeyManagementException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return sslClient;
    }

    public static void addHttpHooks(List<HttpHook> hooks) {
        GLOBAL_HOOKS.addAll(hooks);
    }

    public static void removeHttpHook(HttpHook hook) {
        GLOBAL_HOOKS.remove(hook);
    }

    public static List<HttpHook> getHttpHooks() {
        return Collections.unmodifiableList(GLOBAL_HOOKS);
    }

    public static synchronized void initHttpHookInvokers() {
        if (LOADED_INVOKERS.compareAndSet(false, true)) {
            List<HttpHook> interceptors = EnhancedServiceLoader.loadAll(HttpHook.class);
            HttpBase.addHttpHooks(interceptors);
            List<AbstractHttpInvokerHandler> hookInvokers = EnhancedServiceLoader.loadAll(AbstractHttpInvokerHandler.class);
            AbstractHttpInvokerHandler lastInvoker = HEADER_HANDLER;
            for (AbstractHttpInvokerHandler invoker : hookInvokers) {
                lastInvoker.setNext(invoker);
                lastInvoker = invoker;
            }
            lastInvoker.setNext(TAIL_HANDLER);
        }
    }

    public static AbstractHttpInvokerHandler getHeaderHttpHookInvoker() {
        HttpBase.initHttpHookInvokers();
        return HEADER_HANDLER;
    }
}

