/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt.sign;

import com.cusc.nirvana.common.encrypt.Util;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class HMAC {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static String sign(String content, String key, Type algorithm) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            if (Type.HmacSHA224.equals((Object)algorithm) || Type.HmacSHA384.equals((Object)algorithm)) {
                return HMAC.bouncyCastle(content, key, algorithm);
            }
            return HMAC.jdk(content, key, algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException("HMAC " + algorithm.algorithm + e.getMessage());
        }
    }

    private static String jdk(String content, String key, Type algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm.algorithm);
        mac.init(new SecretKeySpec(key.getBytes("UTF-8"), algorithm.algorithm));
        byte[] bytes = mac.doFinal(content.getBytes("UTF-8"));
        return Util.parseByte2HexStr(bytes);
    }

    private static String bouncyCastle(String content, String key, Type algorithm) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException, NoSuchProviderException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm.algorithm, "BC");
        keyGenerator.init(new SecureRandom(key.getBytes("UTF-8")));
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] secret = secretKey.getEncoded();
        SecretKeySpec secretKey0 = new SecretKeySpec(secret, algorithm.algorithm);
        Mac mac = Mac.getInstance(secretKey0.getAlgorithm());
        mac.init(secretKey0);
        byte[] bytes = mac.doFinal(content.getBytes("UTF-8"));
        return Util.parseByte2HexStr(bytes);
    }

    public static enum Type {
        HmacSHA1("HmacSHA1"),
        HmacSHA224("HmacSHA224"),
        HmacSHA256("HmacSHA256"),
        HmacSHA384("HmacSHA384"),
        HmacSHA512("HmacSHA512"),
        HmacMD5("HmacMD5");

        String algorithm;

        private Type(String algorithm) {
            this.algorithm = algorithm;
        }
    }
}

