/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt.sign;

import com.cusc.nirvana.common.encrypt.Util;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DSA {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyPair initKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Exception ex) {
            throw new RuntimeException("[DSA init keyPair]:" + ex.getMessage());
        }
    }

    public static String sign(String content, String privateKey) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(keyFactory.getAlgorithm());
            signature.initSign(priKey);
            signature.update(content.getBytes("UTF-8"));
            byte[] signed = signature.sign();
            return Util.parseByte2HexStr(signed);
        }
        catch (Exception ex) {
            throw new RuntimeException("DSA sign: " + ex.getMessage());
        }
    }

    public static boolean verify(String content, String sign, String publicKey) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Signature signature = Signature.getInstance(keyFactory.getAlgorithm());
            signature.initVerify(pubKey);
            signature.update(content.getBytes("UTF-8"));
            return signature.verify(Util.parseHexStr2Byte(sign));
        }
        catch (Exception ex) {
            throw new RuntimeException("DSA verify: " + ex.getMessage());
        }
    }
}

