/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt.ecc;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ECIES {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyPair initKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Exception ex) {
            throw new RuntimeException("[ECIES initKeyPair]:" + ex.getMessage());
        }
    }

    public static String encrypt(String content, String publicKey) {
        try {
            byte[] decoded = Base64.decodeBase64((String)publicKey);
            ECPublicKey pubKey = (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("ECIES", "BC");
            cipher.init(1, pubKey);
            String outStr = Base64.encodeBase64String((byte[])cipher.doFinal(content.getBytes("UTF-8")));
            return outStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("[ECIES encrypt]: " + ex.getMessage());
        }
    }

    public static String decrypt(String content, String privateKey) {
        try {
            byte[] decoded = Base64.decodeBase64((String)privateKey);
            ECPrivateKey priKey = (ECPrivateKey)KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("ECIES", "BC");
            cipher.init(2, priKey);
            byte[] inputByte = Base64.decodeBase64((byte[])content.getBytes("UTF-8"));
            String outStr = new String(cipher.doFinal(inputByte));
            return outStr;
        }
        catch (Exception ex) {
            throw new RuntimeException("[ECIES decrypt]: " + ex.getMessage());
        }
    }
}

