/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt.ecc;

import com.cusc.nirvana.common.encrypt.Util;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ECDSA {
    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static KeyPair initKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Exception ex) {
            throw new RuntimeException("ECDSA initKeyPair:" + ex.getMessage());
        }
    }

    public static String sign(String content, String privateKey, Type algorithm) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(algorithm.algorithm);
            signature.initSign(priKey);
            signature.update(content.getBytes("UTF-8"));
            byte[] signed = signature.sign();
            return Util.parseByte2HexStr(signed);
        }
        catch (Exception ex) {
            throw new RuntimeException("ECDSA sign:" + ex.getMessage());
        }
    }

    public static boolean verify(String content, String sign, String publicKey, Type algorithm) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return false;
        }
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey));
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
            Signature signature = Signature.getInstance(algorithm.algorithm);
            signature.initVerify(pubKey);
            signature.update(content.getBytes("UTF-8"));
            return signature.verify(Util.parseHexStr2Byte(sign));
        }
        catch (Exception ex) {
            throw new RuntimeException("ECDSA verify:" + ex.getMessage());
        }
    }

    public static enum Type {
        NONEwithECDSA("NONEwithECDSA"),
        RIPEMD160withECDSA("RIPEMD160withECDSA"),
        SHA1withECDSA("SHA1withECDSA"),
        SHA224withECDSA("SHA224withECDSA"),
        SHA384withECDSA("SHA384withECDSA"),
        SHA512withECDSA("SHA512withECDSA");

        String algorithm;

        private Type(String algorithm) {
            this.algorithm = algorithm;
        }
    }
}

