/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common.encrypt;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.codec.binary.Base64;

public class Util {
    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buf.length) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        int i = 0;
        while (i < hexStr.length() / 2) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
            ++i;
        }
        return result;
    }

    public static String privateKey(KeyPair keyPair) {
        byte[] privateKey = keyPair.getPrivate().getEncoded();
        return Base64.encodeBase64String((byte[])privateKey);
    }

    public static String publicKey(KeyPair keyPair) {
        byte[] publicKey = keyPair.getPublic().getEncoded();
        return Base64.encodeBase64String((byte[])publicKey);
    }

    public static void print(KeyPair keyPair) {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String publicKeyStr = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        String privateKeyStr = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        System.out.println(publicKeyStr);
        System.err.println(privateKeyStr);
    }
}

