/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.common;

public class ExceptionUtils {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ExceptionUtils() {
    }

    public static String getFullStackTrace(Throwable t) {
        if (t == null) {
            return "null";
        }
        StackTraceElement[] items = t.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Exception: ");
        stringBuilder.append(t.getMessage());
        stringBuilder.append(LINE_SEPARATOR);
        int i = 0;
        while (i < items.length) {
            stringBuilder.append(" at: ");
            stringBuilder.append(items[i].getClassName());
            stringBuilder.append(".");
            stringBuilder.append(items[i].getMethodName());
            stringBuilder.append("(");
            stringBuilder.append(items[i].getFileName());
            stringBuilder.append(":");
            stringBuilder.append(items[i].getLineNumber());
            stringBuilder.append(")");
            stringBuilder.append(LINE_SEPARATOR);
            ++i;
        }
        return stringBuilder.toString();
    }
}

