package com.cusc.component.uid.service.impl;

import org.apache.commons.lang3.StringUtils;

import com.cusc.component.uid.constant.FormatConstant;
import com.cusc.component.uid.core.Result;
import com.cusc.component.uid.core.ResultGenerator;
import com.cusc.component.uid.service.IDGen;
import com.cusc.component.uid.util.DateUtils;

public class ZeroIDGen implements IDGen {

	@Override
	public Result get(String key) {
		return ResultGenerator.genSuccessResult(0);
	}

	@Override
	public boolean init() {
		return true;
	}

	@Override
	public Result getContinu(String key) {
		// TODO Auto-generated method stub
		return ResultGenerator.genSuccessResult(0);
	}

	@Override
	public Result getDayContinueCode(String domainKey, String prefixCode, String dayFormat, String codeFormat) {
		String dateTime = DateUtils.dateTime();
		String codeInitial = FormatConstant.CODE_FORMAT;

		if (StringUtils.isNotBlank(dayFormat)) {
			dateTime = DateUtils.dateTimeNow(codeFormat);
		}

		if (StringUtils.isNotBlank(codeFormat)) {
			codeInitial = codeFormat;
		}
		StringBuffer sb = new StringBuffer();
		sb.append(prefixCode);
		sb.append(dateTime);
		sb.append(codeInitial);
		return ResultGenerator.genSuccessResult(sb.toString());
	}
}
