//package com.cusc.component.uid.service.impl;
//
//import javax.annotation.PostConstruct;
//
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import com.cusc.component.uid.config.SnowflakeConfig;
//import com.cusc.component.uid.core.Result;
//import com.cusc.component.uid.dao.IDAllocDao;
//import com.cusc.component.uid.dao.impl.IDAllocDaoImpl;
//import com.cusc.component.uid.exception.InitException;
//import com.cusc.component.uid.service.IDGen;
//import com.cusc.component.uid.util.RedisCenter;
//
//
//@Service("SnowflakeService")
//public class SnowflakeService {
//
//	private Logger logger = LoggerFactory.getLogger(SnowflakeService.class);
//
//	IDGen idGen;
//
//	@Autowired
//	SnowflakeConfig snowflakeConfig;
//	@Autowired
//	RedisCenter redisService;
//
//	@PostConstruct
//	public void init() throws InitException {
//		logger.info("雪花算法模式是否开启：{}", snowflakeConfig.isEnable());
//		if (snowflakeConfig.isEnable()) {
//			// Config Dao
//			IDAllocDao dao = new IDAllocDaoImpl(redisService);
//			idGen = new SnowflakeIDGenImpl(snowflakeConfig.getAddress(), snowflakeConfig.getPort());
//			((SnowflakeIDGenImpl) idGen).setDao(dao);
//			if (idGen.init()) {
//				logger.info("Snowflake Service Init Successfully");
//			} else {
//				throw new InitException("Snowflake Service Init Fail");
//			}
//		} else {
//			idGen = new ZeroIDGen();
//			logger.info("Zero ID Gen Service Init Successfully");
//		}
//	}
//
//	public Result getId(String key) {
//		return idGen.get(key);
//	}
//}
