//package com.cusc.component.uid.service.impl;
//
//import java.util.ArrayList;
//import java.util.List;
//import java.util.Random;
//import java.util.concurrent.Executors;
//import java.util.concurrent.ScheduledExecutorService;
//import java.util.concurrent.ThreadFactory;
//import java.util.concurrent.TimeUnit;
//
//import org.perf4j.StopWatch;
//import org.perf4j.slf4j.Slf4JStopWatch;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import com.cusc.component.uid.core.Result;
//import com.cusc.component.uid.core.ResultCode;
//import com.cusc.component.uid.core.ResultGenerator;
//import com.cusc.component.uid.dao.IDAllocDao;
//import com.cusc.component.uid.service.IDGen;
//import com.cusc.component.uid.util.SnowflakeZookeeperHolder;
//import com.cusc.component.uid.util.Utils;
//import com.google.common.base.Preconditions;
//
//public class SnowflakeIDGenImpl implements IDGen {
//
//	private static final Logger LOGGER = LoggerFactory.getLogger(SnowflakeIDGenImpl.class);
//	
//	private static final long TWEPOCH = 1288834974657L;
//	private static final long WORKER_ID_BITS = 10L;
//	private static final long MAX_WORKER_ID = -1L ^ (-1L << WORKER_ID_BITS);// 最大能够分配的workerid =1023
//	private static final long SEQUENCE_BITS = 12L;
//	private static final long WORKER_ID_SHIFT = SEQUENCE_BITS;
//	private static final long TIMESTAMP_LEFT_SHIFT = SEQUENCE_BITS + WORKER_ID_BITS;
//	private static final long SEQUENCE_MASK = -1L ^ (-1L << SEQUENCE_BITS);
//	
//	private static long workerId;
//	private static long sequence = 0L;
//	private static long lastTimestamp = -1L;
//	private static boolean initFlag = false;
//	private static final Random RANDOM = new Random();
//	
//	private volatile boolean initOK = false;
//	private List<String> cache = new ArrayList<>();
//
//	private IDAllocDao dao;
//	@SuppressWarnings("unused")
//	private int port;
//
//	@Override
//	public boolean init() {
//		LOGGER.info("snow init...");
//		updateCacheFromDb();
//		initOK = true;
//		updateCacheFromDbAtEveryMinute();
//		return initOK;
//	}
//	
//	private void updateCacheFromDb() {
//		LOGGER.info("snow update cache from db");
//		StopWatch sw = new Slf4JStopWatch();
//		try {
//			List<String> dbTags = dao.getAllKeys();
//			if (dbTags == null || dbTags.isEmpty()) {
//				return;
//			}
//			List<String> cacheTags = new ArrayList<String>(cache);
//			List<String> insertTags = new ArrayList<String>(dbTags);
//			List<String> removeTags = new ArrayList<String>(cacheTags);
//			// db中新加的tags灌进cache
//			insertTags.removeAll(cacheTags);
//			for (String tag : insertTags) {
//				cache.add(tag);
//				LOGGER.info("Add tag {} from db to IdCache", tag);
//			}
//			// cache中已失效的tags从cache删除
//			removeTags.removeAll(dbTags);
//			for (String tag : removeTags) {
//				cache.remove(tag);
//				LOGGER.info("Remove tag {} from IdCache", tag);
//			}
//		} catch (Exception e) {
//			LOGGER.warn("update cache from db exception", e);
//		} finally {
//			sw.stop("updateCacheFromDb");
//		}
//	}
//	
//	private void updateCacheFromDbAtEveryMinute() {
//		ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory() {
//			@Override
//			public Thread newThread(Runnable r) {
//				Thread t = new Thread(r);
//				t.setName("snow-check-idCache-thread");
//				t.setDaemon(true);
//				return t;
//			}
//		});
//		service.scheduleWithFixedDelay(new Runnable() {
//			@Override
//			public void run() {
//				updateCacheFromDb();
//			}
//		}, 60, 60, TimeUnit.SECONDS);
//	}
//
//	public SnowflakeIDGenImpl(String zkAddress, int port) {
//		this.port = port;
//		SnowflakeZookeeperHolder holder = new SnowflakeZookeeperHolder(Utils.getIp(), String.valueOf(port), zkAddress);
//		initFlag = holder.init();
//		if (initFlag) {
//			workerId = holder.getWorkerID();
//			LOGGER.info("START SUCCESS USE ZK WORKERID-{}", workerId);
//		} else {
//			Preconditions.checkArgument(initFlag, "Snowflake Id Gen is not init ok");
//		}
//		Preconditions.checkArgument(workerId >= 0 && workerId <= MAX_WORKER_ID, "workerID must gte 0 and lte 1023");
//	}
//
//	public synchronized Result get(String key) {
//		if (!cache.contains(key)) {
//			return ResultGenerator.genFailResult(ResultCode.ID_KEY_NOT_EXISTS, "key不存在，联系中间件申请!");
//		}
//		long timestamp = timeGen();
//		if (timestamp < lastTimestamp) {
//			long offset = lastTimestamp - timestamp;
//			if (offset <= 5) {
//				try {
//					wait(offset << 1);
//					timestamp = timeGen();
//					if (timestamp < lastTimestamp) {
//						return ResultGenerator.genFailResult(ResultCode.TIME_CALLBACK_EXCEPTION, "服务器时间发生回拨，获取uid失败!");
//					}
//				} catch (InterruptedException e) {
//					LOGGER.error("wait interrupted");
//					 Thread.currentThread().interrupt();
//					return ResultGenerator.genFailResult(ResultCode.THREAD_INTERRUPTED_EXCEPTION, "服务器时间回拨，线程等待异常!");
//				}
//			} else {
//				return ResultGenerator.genFailResult(ResultCode.TIME_CALLBACK_EXCEPTION, "服务器时间回拨大于五毫秒，超出等待时间5毫秒！");
//			}
//		}
//		if (lastTimestamp == timestamp) {
//			sequence = (sequence + 1) & SEQUENCE_MASK;
//			if (sequence == 0) {
//				// seq 为0的时候表示是下一毫秒时间开始对seq做随机
//				sequence = RANDOM.nextInt(100);
//				timestamp = tilNextMillis(lastTimestamp);
//			}
//		} else {
//			// 如果是新的ms开始
//			sequence = RANDOM.nextInt(100);
//		}
//		lastTimestamp = timestamp;
//		long id = ((timestamp - TWEPOCH) << TIMESTAMP_LEFT_SHIFT) | (workerId << WORKER_ID_SHIFT) | sequence;
//		return ResultGenerator.genSuccessResult(id);
//	}
//
//	protected long tilNextMillis(long lastTimestamp) {
//		long timestamp = timeGen();
//		while (timestamp <= lastTimestamp) {
//			timestamp = timeGen();
//		}
//		return timestamp;
//	}
//
//	protected long timeGen() {
//		return System.currentTimeMillis();
//	}
//
//	public long getWorkerId() {
//		return workerId;
//	}
//
//	public List<String> getCache() {
//		return cache;
//	}
//
//	public IDAllocDao getDao() {
//		return dao;
//	}
//
//	public void setDao(IDAllocDao dao) {
//		this.dao = dao;
//	}
//
//	@Override
//	public Result getContinu(String key) {
//		// TODO Auto-generated method stub
//		return ResultGenerator.genSuccessResult(0);
//	}
//}
